/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.gui.textfield.TextView;
import br.com.etyllica.layer.BufferedLayer;
import br.com.etyllica.theme.Theme;
import br.com.etyllica.theme.ThemeManager;
import java.awt.Color;
import java.awt.FontMetrics;

public class TextField
extends TextView {
    private BufferedLayer layer;
    private boolean shift = false;
    private boolean control = false;

    public TextField(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.layer = new BufferedLayer(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        if (keyEvent.getChar() != '\u0000') {
            this.updateChar(keyEvent.getChar());
        }
        GUIEvent gUIEvent = this.updatePressed(keyEvent);
        GUIEvent gUIEvent2 = this.updateReleased(keyEvent);
        this.minMark = this.getMinMark();
        this.maxMark = this.getMaxMark();
        if (gUIEvent != GUIEvent.NONE) {
            return gUIEvent;
        }
        if (gUIEvent2 != GUIEvent.NONE) {
            return gUIEvent2;
        }
        return GUIEvent.NONE;
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        if (pointerEvent.isButtonDown(MouseButton.MOUSE_BUTTON_LEFT)) {
            if (this.mouseOver) {
                return GUIEvent.GAIN_FOCUS;
            }
            return GUIEvent.LOST_FOCUS;
        }
        if (this.mouseOver) {
            if (!this.onFocus) {
                return GUIEvent.MOUSE_OVER;
            }
            return GUIEvent.MOUSE_OVER_WITH_FOCUS;
        }
        return GUIEvent.NONE;
    }

    private GUIEvent updatePressed(KeyEvent keyEvent) {
        if (!this.shift) {
            if (keyEvent.isKeyDown(316) || keyEvent.isKeyDown(216)) {
                this.shift = true;
                this.fixMark = this.cursor;
            } else if (keyEvent.isKeyDown(37) || keyEvent.isKeyDown(39)) {
                this.fixMark = -1;
            }
        }
        if (keyEvent.isKeyDown(35)) {
            this.cursor = this.text.length();
        } else if (keyEvent.isKeyDown(36)) {
            this.moveCursorToStart();
        }
        if (!this.control && (keyEvent.isKeyDown(317) || keyEvent.isKeyDown(217))) {
            this.control = true;
        }
        if (keyEvent.isKeyDown(37)) {
            if (this.control) {
                this.leftWithControl();
            } else {
                this.leftNormal();
            }
        } else if (keyEvent.isKeyDown(39)) {
            if (this.control) {
                this.rightWithControl();
            } else {
                this.rightNormal();
            }
        }
        if (keyEvent.isKeyDown(9)) {
            return GUIEvent.NEXT_COMPONENT;
        }
        return GUIEvent.NONE;
    }

    private GUIEvent updateReleased(KeyEvent keyEvent) {
        if (this.control && (keyEvent.isKeyDown(317) || keyEvent.isKeyDown(217))) {
            this.control = false;
        }
        if (this.shift && (keyEvent.isKeyDown(316) || keyEvent.isKeyDown(216))) {
            this.shift = false;
        }
        return GUIEvent.NONE;
    }

    @Override
    public void draw(Graphic graphic) {
        int n;
        int n2;
        Theme theme = ThemeManager.getInstance().getTheme();
        graphic.setImage(this.layer.getBuffer());
        int n3 = 0;
        int n4 = 0;
        String string = this.getText();
        int n5 = theme.getFontSize();
        FontMetrics fontMetrics = graphic.getGraphics().getFontMetrics();
        float f = this.w - fontMetrics.stringWidth(string);
        if (this.onFocus) {
            graphic.setColor(theme.getTextFieldColor());
        } else {
            graphic.setColor(theme.getTextFieldWithoutFocusColor());
        }
        if (this.mouseOver) {
            graphic.setColor(theme.getTextFieldOnMouseColor());
        }
        graphic.drawRect(n3, n4, this.w, this.h);
        graphic.setColor(theme.getTextColor());
        if (this.minMark == 0 && this.maxMark == 0) {
            if (f > 0.0f) {
                graphic.drawShadow(n3, n4 + this.h / 2 + n5 / 2, string);
            } else {
                graphic.drawShadow((float)n3 + f, (float)(n4 + this.h / 2 + n5 / 2), string);
            }
        } else {
            n2 = fontMetrics.stringWidth(string.substring(0, this.minMark));
            n = fontMetrics.stringWidth(string.substring(this.minMark, this.maxMark));
            graphic.setColor(theme.getSelectionTextColor());
            graphic.fillRect(n3 + n2 + 2, n4 + 2, n, this.h - 3);
            graphic.setColor(theme.getTextColor());
            graphic.drawShadow(n3, n4 + this.h / 2 + n5 / 2, string.substring(0, this.minMark));
            graphic.setColor(theme.getTextSelectedColor());
            graphic.drawShadow(n3 + n2, n4 + this.h / 2 + n5 / 2, string.substring(this.minMark, this.maxMark), Color.WHITE);
            graphic.setColor(theme.getTextColor());
            graphic.drawShadow(n3 + n2 + n, n4 + this.h / 2 + n5 / 2, string.substring(this.maxMark, string.length()), Color.WHITE);
        }
        if (this.onFocus) {
            graphic.setColor(theme.getTextFieldColor());
            n2 = fontMetrics.stringWidth(string.substring(0, this.cursor));
            n2 += n3 + 1;
            n = 3;
            if (f > 0.0f) {
                graphic.drawLine(n2 + 1, n4 + n, n2 + 1, n4 + this.h - n);
            } else {
                graphic.drawLine(f + (float)n2, (float)(n4 + n), f + (float)n2, (float)(n4 + this.h - n));
            }
        }
        graphic.resetImage();
        this.layer.draw(graphic);
        this.layer.resetImage();
    }

    @Override
    protected void notifyTextChanged() {
        super.notifyTextChanged();
    }

    @Override
    public void update(GUIEvent gUIEvent) {
        switch (gUIEvent) {
            case GAIN_FOCUS: {
                this.onFocus = true;
                break;
            }
            case LOST_FOCUS: {
                this.onFocus = false;
                break;
            }
            case MOUSE_OVER_WITH_FOCUS: 
            case MOUSE_OVER: {
                this.mouseOver = true;
                break;
            }
            case MOUSE_OUT: {
                this.mouseOver = false;
                break;
            }
        }
    }

    private void updateChar(char c) {
        if ('\b' == c) {
            this.eraseAsBackSpace();
        } else if ('\u007f' == c) {
            this.eraseAsDelete();
        } else if ('\n' != c && '\t' != c && '\u001b' != c) {
            if (this.maxLength > 0) {
                if (this.text.length() < this.maxLength) {
                    this.addChar(c);
                }
            } else {
                this.addChar(c);
            }
        }
    }

    public String getText() {
        this.text = this.text.replace("\n", "").replace("\r", "");
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

