/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.Drawable;
import br.com.etyllica.core.event.Action;
import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.gui.GUIComponent;
import br.com.etyllica.layer.Layer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class View
extends Layer
implements GUIComponent,
Drawable {
    protected GUIEvent lastEvent = GUIEvent.NONE;
    protected boolean onFocus = false;
    protected boolean mouseOver = false;
    protected View root = null;
    private List<View> views = new ArrayList<View>();
    protected List<Action> actions = new ArrayList<Action>();
    protected Map<GUIEvent, Action> actionMap = new HashMap<GUIEvent, Action>();

    public View(int n, int n2) {
        super(n, n2, 1, 1);
    }

    public View(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public View() {
        super(0, 0);
    }

    public GUIEvent getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(GUIEvent gUIEvent) {
        this.lastEvent = gUIEvent;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(boolean bl) {
        this.mouseOver = bl;
    }

    public boolean isOnFocus() {
        return this.onFocus;
    }

    public void setOnFocus(boolean bl) {
        this.onFocus = bl;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> list) {
        this.actions = list;
    }

    public synchronized List<View> getViews() {
        return this.views;
    }

    public void clearComponents() {
        this.views.clear();
    }

    public void remove(View view) {
        this.views.remove(view);
    }

    public void removeAll(Collection<? extends View> collection) {
        this.views.removeAll(collection);
    }

    public void add(View view) {
        view.setRoot(this);
        this.views.add(view);
    }

    public void addAll(Collection<? extends View> collection) {
        for (View view : collection) {
            this.add(view);
        }
    }

    public void translateComponents(int n, int n2) {
        for (View view : this.views) {
            this.translateComponent(n, n2, view);
        }
    }

    private void translateComponent(int n, int n2, View view) {
        view.setOffset(n, n2);
        for (View view2 : view.views) {
            this.translateComponent(n, n2, view2);
        }
    }

    public void executeAction(GUIEvent gUIEvent) {
        if (this.actionMap.containsKey((Object)gUIEvent)) {
            this.actionMap.get((Object)gUIEvent).executeAction();
        }
    }

    public void addAction(GUIEvent gUIEvent, Action action) {
        this.actionMap.put(gUIEvent, action);
    }

    protected void setRoot(View view) {
        this.root = view;
    }

    public View findNext() {
        if (this.root != null) {
            Iterator<View> iterator = this.root.getViews().iterator();
            while (iterator.hasNext()) {
                if (!this.equals(iterator.next()) || !iterator.hasNext()) continue;
                return iterator.next();
            }
        }
        return null;
    }

    @Override
    public void resize(int n, int n2) {
    }
}

