/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.factory;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.event.PointerState;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.gui.Label;
import br.com.etyllica.gui.RoundGUIComponent;
import br.com.etyllica.theme.Theme;
import br.com.etyllica.theme.ThemeManager;

public class DefaultButton
extends RoundGUIComponent {
    protected Label label;
    private Theme theme;
    private String alt = "";
    protected boolean clicked = false;
    protected boolean disabled = false;

    public DefaultButton(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    @Override
    public void draw(Graphic graphic) {
        if (!this.visible) {
            return;
        }
        Theme theme = this.getTheme();
        if (!this.disabled) {
            if (!this.mouseOver) {
                graphic.setColor(theme.getButtonColor());
            } else if (this.clicked) {
                graphic.setColor(theme.getButtonOnClick());
            } else {
                graphic.setColor(theme.getButtonOnMouse());
            }
        } else {
            graphic.setColor(theme.getButtonDisabledColor());
        }
        graphic.fillRect(this.x, this.y, this.w, this.h);
        this.drawLabel(graphic);
    }

    protected void drawLabel(Graphic graphic) {
        if (this.hasLabel()) {
            this.label.draw(graphic);
        }
    }

    @Override
    public void update(GUIEvent gUIEvent) {
        this.executeAction(gUIEvent);
        if (this.hasLabel()) {
            this.label.update(gUIEvent);
        }
    }

    protected void leftClick() {
    }

    protected void leftUp() {
    }

    protected void middleClick() {
    }

    protected void rightClick() {
    }

    protected void justOnMouse() {
    }

    protected void mouseOut() {
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        GUIEvent gUIEvent = GUIEvent.NONE;
        if (!this.disabled) {
            if (this.mouseOver) {
                if (pointerEvent.getState() == PointerState.PRESSED) {
                    if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_LEFT)) {
                        this.clicked = true;
                        this.leftClick();
                        gUIEvent = GUIEvent.MOUSE_LEFT_BUTTON_DOWN;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_RIGHT)) {
                        this.rightClick();
                        gUIEvent = GUIEvent.MOUSE_RIGHT_BUTTON_DOWN;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_MIDDLE)) {
                        this.middleClick();
                        gUIEvent = GUIEvent.MOUSE_MIDDLE_BUTTON_DOWN;
                    }
                } else if (pointerEvent.getState() == PointerState.RELEASED) {
                    if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_LEFT)) {
                        this.clicked = false;
                        this.leftUp();
                        gUIEvent = GUIEvent.MOUSE_LEFT_BUTTON_UP;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_RIGHT)) {
                        gUIEvent = GUIEvent.MOUSE_RIGHT_BUTTON_UP;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_MIDDLE)) {
                        gUIEvent = GUIEvent.MOUSE_MIDDLE_BUTTON_UP;
                    }
                } else if (pointerEvent.getState() == PointerState.DOUBLE_CLICK) {
                    if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_LEFT)) {
                        gUIEvent = GUIEvent.MOUSE_LEFT_BUTTON_DOUBLE_CLICK;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_RIGHT)) {
                        gUIEvent = GUIEvent.MOUSE_RIGHT_BUTTON_DOUBLE_CLICK;
                    } else if (pointerEvent.isKey(MouseButton.MOUSE_BUTTON_MIDDLE)) {
                        gUIEvent = GUIEvent.MOUSE_MIDDLE_BUTTON_DOUBLE_CLICK;
                    }
                } else if (pointerEvent.getState() == PointerState.MOVE) {
                    this.justOnMouse();
                    gUIEvent = GUIEvent.MOUSE_OVER;
                }
            } else if (pointerEvent.getState() == PointerState.MOVE) {
                this.mouseOut();
                gUIEvent = GUIEvent.MOUSE_OUT;
            } else if (pointerEvent.isButtonDown(MouseButton.MOUSE_BUTTON_LEFT)) {
                this.onFocus = false;
            }
        }
        this.update(gUIEvent);
        return gUIEvent;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
        label.setX(this.x + (this.w / 2 - label.getW() / 2) + label.getX());
        label.setY(this.y + (this.h / 2 - label.getH() / 2) + label.getY());
        label.setContentBounds(this.x, this.y, this.w, this.h);
    }

    public void setCenterLabel(Label label) {
        this.label = label;
        label.setX(label.getX() + (this.x + this.w / 2 - label.getW() / 2));
        label.setY(label.getY() + (this.y + this.h / 2 - label.getH() / 2));
        label.setContentBounds(this.x, this.y, this.w, this.h);
    }

    @Override
    public void setX(int n) {
        super.setX(n);
        if (this.hasLabel()) {
            this.label.setContentBounds(n, this.y, this.w, this.h);
        }
    }

    @Override
    public void setY(int n) {
        super.setY(n);
        if (this.hasLabel()) {
            this.label.setContentBounds(this.x, n, this.w, this.h);
        }
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        if (keyEvent.isKeyDown(9)) {
            return GUIEvent.NEXT_COMPONENT;
        }
        if (keyEvent.isKeyDown(10)) {
            this.update(GUIEvent.MOUSE_LEFT_BUTTON_DOWN);
        }
        return GUIEvent.NONE;
    }

    protected boolean hasLabel() {
        return this.label != null;
    }

    public Theme getTheme() {
        if (this.theme == null) {
            return ThemeManager.getInstance().getTheme();
        }
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean isClicked() {
        return this.clicked;
    }
}

