/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.label;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.gui.Label;
import br.com.etyllica.layer.GeometricLayer;
import br.com.etyllica.layer.TextLayer;
import br.com.etyllica.theme.Theme;
import br.com.etyllica.theme.ThemeManager;
import java.awt.Color;

public class TextLabel
extends Label {
    protected TextLayer layer;

    public TextLabel(int n, int n2) {
        super(n, n2);
        this.layer = new TextLayer(n, n2, "");
    }

    public TextLabel(int n, int n2, int n3) {
        super(n, n2, n3);
        this.layer = new TextLayer(n, n2, "");
    }

    public TextLabel(int n, int n2, String string) {
        super(n, n2);
        this.layer = new TextLayer(n, n2, string);
    }

    public TextLabel(String string) {
        this(0, 0, string);
    }

    public TextLabel(String string, float f) {
        this(0, 0, string);
        this.layer.setSize(f);
    }

    @Override
    public void setX(int n) {
        this.x = n;
        this.layer.setX(n);
    }

    @Override
    public void setY(int n) {
        this.y = n;
        this.layer.setY(n);
    }

    @Override
    public void update(GUIEvent gUIEvent) {
        switch (gUIEvent) {
            case LOST_FOCUS: {
                this.onFocus = false;
                break;
            }
            case GAIN_FOCUS: {
                this.onFocus = true;
                break;
            }
        }
    }

    @Override
    public void draw(Graphic graphic) {
        Theme theme = ThemeManager.getInstance().getTheme();
        graphic.setFont(theme.getFont().deriveFont(this.layer.getSize()));
        if (!this.onFocus) {
            graphic.setColor(theme.getTextColor());
        } else {
            graphic.setColor(theme.getButtonOnFocus());
        }
        if (!theme.isShadow()) {
            graphic.drawString(this.bx, this.by, this.bw, this.bh, this.layer.getText());
        } else {
            graphic.drawStringShadow(this.bx, this.by, this.bw, this.bh, this.layer.getText(), theme.getShadowColor());
        }
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        if (keyEvent.isKeyDown(9)) {
            return GUIEvent.NEXT_COMPONENT;
        }
        return GUIEvent.NONE;
    }

    public String getText() {
        return this.layer.getText();
    }

    public void setText(String string) {
        this.layer.setText(string);
    }

    public float getFontSize() {
        return this.layer.getSize();
    }

    public void setFontSize(int n) {
        this.layer.setSize(n);
    }

    public void setBorder(boolean bl) {
        this.layer.setBorder(bl);
    }

    public void setBorderColor(Color color) {
        this.layer.setBorderColor(color);
    }

    public void setBorderWidth(int n) {
        this.layer.setBorderWidth(n);
    }

    @Override
    public void centralize(int n, int n2, int n3, int n4) {
        this.layer.centralize(n, n2, n3, n4);
    }

    @Override
    public void centralize(GeometricLayer geometricLayer) {
        geometricLayer.centralize(geometricLayer);
    }

    @Override
    public void centralizeX(GeometricLayer geometricLayer) {
        geometricLayer.centralizeX(geometricLayer);
    }

    @Override
    public int centralizeX(int n, int n2) {
        return this.layer.centralizeX(n, n2);
    }

    @Override
    public void centralizeY(GeometricLayer geometricLayer) {
        geometricLayer.centralizeY(geometricLayer);
    }

    @Override
    public int centralizeY(int n, int n2) {
        return this.layer.centralizeY(n, n2);
    }
}

