/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.i18n;

import br.com.etyllica.i18n.Language;
import java.util.HashMap;
import java.util.Map;

public abstract class Dictionary {
    protected Map<String, Map<Language, String>> vocabulary;
    protected Language defaultLanguage = Language.ENGLISH_USA;

    public Dictionary() {
        this.vocabulary = new HashMap<String, Map<Language, String>>();
        this.populateVocabulary();
    }

    protected abstract void populateVocabulary();

    public Map<Language, String> getWord(String string) {
        return this.vocabulary.get(string);
    }

    public String getTranslatedWord(String string, Language language) {
        Map<Language, String> map = this.vocabulary.get(string);
        if (map.containsKey((Object)language)) {
            return map.get((Object)language);
        }
        return map.get((Object)this.defaultLanguage);
    }
}

