/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.layer.ImageLayer;
import java.awt.geom.AffineTransform;

public class PivotImageLayer
extends ImageLayer {
    protected int xPivot = 0;
    protected int yPivot = 0;

    public PivotImageLayer(int n, int n2) {
        super(n, n2);
    }

    public PivotImageLayer(int n, int n2, String string) {
        super(n, n2, string);
        this.xPivot = this.w / 2;
        this.yPivot = this.h / 2;
    }

    public void setPivotCoordinates(int n, int n2) {
        this.xPivot = n;
        this.yPivot = n2;
    }

    public int getXPivot() {
        return this.xPivot;
    }

    public int getYPivot() {
        return this.yPivot;
    }

    @Override
    public boolean colisionRotated(int n, int n2) {
        int n3 = this.x + this.xPivot;
        int n4 = this.y + this.yPivot;
        double d = Math.cos(Math.toRadians(-this.angle));
        double d2 = Math.sin(Math.toRadians(-this.angle));
        double d3 = (double)n3 + d * (double)(n - n3) - d2 * (double)(n2 - n4);
        double d4 = (double)n4 + d2 * (double)(n - n3) + d * (double)(n2 - n4);
        int n5 = n3 - this.xPivot;
        int n6 = n3 - this.xPivot + this.w;
        int n7 = n4 - this.yPivot;
        int n8 = n4 - this.yPivot + this.h;
        return (double)n5 <= d3 && d3 <= (double)n6 && (double)n7 <= d4 && d4 <= (double)n8;
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform affineTransform = null;
        if (this.angle != 0.0) {
            affineTransform = new AffineTransform();
            affineTransform = AffineTransform.getRotateInstance(Math.toRadians(this.angle), this.x + this.xPivot, this.y + this.yPivot);
        }
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            if (affineTransform == null) {
                affineTransform = new AffineTransform();
            }
            double d = (double)this.w * this.scaleX;
            double d2 = (double)this.h * this.scaleY;
            double d3 = d / 2.0 - (double)(this.w / 2);
            double d4 = d2 / 2.0 - (double)(this.h / 2);
            affineTransform.translate((double)(this.x - this.w / 2) - d3, (double)(this.y - this.h / 2) - d4);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(this.w / 2, this.h / 2);
            affineTransform2.scale(this.scaleX, this.scaleY);
            affineTransform2.translate(-this.x, -this.y);
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }
}

