/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.loader.FontLoader;
import br.com.etyllica.layer.ImageLayer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class TextLayer
extends ImageLayer {
    private String text;
    private int style = 0;
    private float size = 16.0f;
    private Font font = null;
    private String fontName = "";
    private Color color = Color.BLACK;
    private Color borderColor = Color.GRAY;
    private boolean border = false;
    private float borderWidth = 4.0f;
    private boolean antiAliased = true;
    private boolean fractionalMetrics = false;

    public TextLayer(String string) {
        this(0, 0, string);
    }

    public TextLayer(int n, int n2, String string) {
        super(n, n2);
        this.setText(string);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float f) {
        this.size = f;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
        this.font = FontLoader.getInstance().loadFont(string).deriveFont(this.style, this.size);
    }

    @Override
    public void simpleDraw(Graphic graphic, int n, int n2) {
        if (this.font == null) {
            this.font = graphic.getFont().deriveFont(this.style, this.size);
        }
        graphic.setFont(this.font);
        if (!this.border) {
            graphic.setColor(this.color);
            graphic.write(n, n2, this.text);
        } else {
            FontRenderContext fontRenderContext = new FontRenderContext(null, this.antiAliased, this.fractionalMetrics);
            TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
            Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n, n2));
            graphic.setStroke(new BasicStroke(this.borderWidth));
            graphic.setColor(this.borderColor);
            graphic.draw(shape);
            graphic.setColor(this.color);
            graphic.fill(shape);
        }
    }

    @Override
    public AffineTransform getTransform() {
        if (this.font == null) {
            return AffineTransform.getScaleInstance(1.0, 1.0);
        }
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(null, this.antiAliased, this.fractionalMetrics);
        TextLayout textLayout = new TextLayout(this.text, this.font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = this.size;
        float f2 = (float)Math.ceil(rectangle2D.getWidth());
        if (this.angle != 0.0) {
            affineTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(this.angle), this.x + this.w / 2, this.y + this.h / 2));
        }
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            double d = (double)f2 * this.scaleX;
            double d2 = (double)f * this.scaleY;
            double d3 = d / 2.0 - (double)(f2 / 2.0f);
            double d4 = d2 / 2.0 - (double)(f / 2.0f);
            affineTransform.translate((double)((float)this.x - f2 / 2.0f) - d3, (double)((float)this.y - f / 2.0f) + d4);
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(f2 / 2.0f, f / 2.0f);
            affineTransform2.scale(this.scaleX, this.scaleY);
            affineTransform2.translate(-this.x, -this.y);
            affineTransform.concatenate(affineTransform2);
        }
        return affineTransform;
    }

    public void setColor(int n, int n2, int n3) {
        this.color = new Color(n % 256, n2 % 256, n3 % 256);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setText(String string) {
        if (!string.isEmpty()) {
            this.text = string;
            this.computeBoundingBox();
        } else {
            this.text = " ";
        }
    }

    private void computeBoundingBox() {
        Font font = this.font != null ? this.font : new Font("Dialog", 0, (int)this.size);
        FontRenderContext fontRenderContext = new FontRenderContext(null, this.antiAliased, this.fractionalMetrics);
        TextLayout textLayout = new TextLayout(this.text, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        this.h = (int)this.size;
        this.w = (int)Math.ceil(rectangle2D.getWidth());
    }

    public void setBorder(boolean bl) {
        this.border = bl;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isBorder() {
        return this.border;
    }

    public String getText() {
        return this.text;
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        this.antiAliased = bl;
    }

    public boolean isFractionalMetrics() {
        return this.fractionalMetrics;
    }

    public void setFractionalMetrics(boolean bl) {
        this.fractionalMetrics = bl;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }
}

