/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.linear;

public class Point2D {
    protected String name = "";
    protected double x = 0.0;
    protected double y = 0.0;
    protected int color = 0;

    public Point2D() {
        this.setLocation(0.0, 0.0);
    }

    public Point2D(double d, double d2, int n) {
        this(d, d2);
        this.color = n;
    }

    public Point2D(double d, double d2, String string) {
        this(d, d2);
        this.name = string;
    }

    public Point2D(double d, double d2) {
        this.setLocation(d, d2);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setOffset(double d, double d2) {
        this.setOffsetX(d);
        this.setOffsetY(d2);
    }

    public void setOffsetX(double d) {
        this.x += d;
    }

    public void setOffsetY(double d) {
        this.y += d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public double angle(Point2D point2D) {
        return this.angle(point2D.getX(), point2D.getY());
    }

    public double angle(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        double d5 = Math.atan2(d4, d3) * 180.0 / Math.PI;
        return d5;
    }

    public static double angle(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        double d7 = Math.atan2(d6, d5) * 180.0 / Math.PI;
        return d7;
    }

    public void rotate(double d, double d2, double d3) {
        double d4 = Math.toRadians(d3);
        double d5 = d + (this.x - d) * Math.cos(d4) - (this.y - d2) * Math.sin(d4);
        double d6 = d2 + (this.x - d) * Math.sin(d4) + (this.y - d2) * Math.cos(d4);
        this.x = d5;
        this.y = d6;
    }

    public static boolean isRightTurn(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return (point2D2.x - point2D.x) * (point2D3.y - point2D.y) - (point2D2.y - point2D.y) * (point2D3.x - point2D.x) > 0.0;
    }

    public double distance(Point2D point2D) {
        return this.distance(point2D.getX(), point2D.getY());
    }

    public double distance(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        double d5 = Math.sqrt(Math.pow(d3, 2.0) + Math.pow(d4, 2.0));
        return d5;
    }

    public static Point2D clone(Point2D point2D) {
        return new Point2D(point2D.getX(), point2D.getY());
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Point2D point2D = (Point2D)object;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(point2D.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(point2D.y);
    }
}

