/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.kdtree;

import br.com.etyllica.util.kdtree.Checker;
import br.com.etyllica.util.kdtree.Editor;
import br.com.etyllica.util.kdtree.HPoint;
import br.com.etyllica.util.kdtree.HRect;
import br.com.etyllica.util.kdtree.KeyDuplicateException;
import br.com.etyllica.util.kdtree.NearestNeighborList;
import java.io.Serializable;
import java.util.List;

class KDNode<T>
implements Serializable {
    protected HPoint k;
    T v;
    protected KDNode<T> left;
    protected KDNode<T> right;
    protected boolean deleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> int edit(HPoint hPoint, Editor<T> editor, KDNode<T> kDNode, int n, int n2) throws KeyDuplicateException {
        KDNode<T> kDNode2 = null;
        int n3 = (n + 1) % n2;
        KDNode<T> kDNode3 = kDNode;
        synchronized (kDNode3) {
            if (hPoint.equals(kDNode.k)) {
                boolean bl = kDNode.deleted;
                kDNode.v = editor.edit(kDNode.deleted ? null : (Object)kDNode.v);
                boolean bl2 = kDNode.deleted = kDNode.v == null;
                if (kDNode.deleted == bl) {
                    return 0;
                }
                if (bl) {
                    return 1;
                }
                return -1;
            }
            if (hPoint.coord[n] > kDNode.k.coord[n]) {
                kDNode2 = kDNode.right;
                if (kDNode2 == null) {
                    kDNode.right = KDNode.create(hPoint, editor);
                    return kDNode.right.deleted ? 0 : 1;
                }
            } else {
                kDNode2 = kDNode.left;
                if (kDNode2 == null) {
                    kDNode.left = KDNode.create(hPoint, editor);
                    return kDNode.left.deleted ? 0 : 1;
                }
            }
        }
        return KDNode.edit(hPoint, editor, kDNode2, n3, n2);
    }

    protected static <T> KDNode<T> create(HPoint hPoint, Editor<T> editor) throws KeyDuplicateException {
        KDNode<Object> kDNode = new KDNode<Object>(hPoint, editor.edit(null));
        if (kDNode.v == null) {
            kDNode.deleted = true;
        }
        return kDNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> boolean del(KDNode<T> kDNode) {
        KDNode<T> kDNode2 = kDNode;
        synchronized (kDNode2) {
            if (!kDNode.deleted) {
                kDNode.deleted = true;
                return true;
            }
        }
        return false;
    }

    protected static <T> KDNode<T> srch(HPoint hPoint, KDNode<T> kDNode, int n) {
        int n2 = 0;
        while (kDNode != null) {
            if (!kDNode.deleted && hPoint.equals(kDNode.k)) {
                return kDNode;
            }
            kDNode = hPoint.coord[n2] > kDNode.k.coord[n2] ? kDNode.right : kDNode.left;
            n2 = (n2 + 1) % n;
        }
        return null;
    }

    protected static <T> void rsearch(HPoint hPoint, HPoint hPoint2, KDNode<T> kDNode, int n, int n2, List<KDNode<T>> list) {
        if (kDNode == null) {
            return;
        }
        if (hPoint.coord[n] <= kDNode.k.coord[n]) {
            KDNode.rsearch(hPoint, hPoint2, kDNode.left, (n + 1) % n2, n2, list);
        }
        if (!kDNode.deleted) {
            int n3;
            for (n3 = 0; n3 < n2 && hPoint.coord[n3] <= kDNode.k.coord[n3] && hPoint2.coord[n3] >= kDNode.k.coord[n3]; ++n3) {
            }
            if (n3 == n2) {
                list.add(kDNode);
            }
        }
        if (hPoint2.coord[n] > kDNode.k.coord[n]) {
            KDNode.rsearch(hPoint, hPoint2, kDNode.right, (n + 1) % n2, n2, list);
        }
    }

    protected static <T> void nnbr(KDNode<T> kDNode, HPoint hPoint, HRect hRect, double d, int n, int n2, NearestNeighborList<KDNode<T>> nearestNeighborList, Checker<T> checker, long l) {
        HRect hRect2;
        KDNode<T> kDNode2;
        HRect hRect3;
        KDNode<T> kDNode3;
        boolean bl;
        if (kDNode == null) {
            return;
        }
        if (l > 0L && l < System.currentTimeMillis()) {
            return;
        }
        int n3 = n % n2;
        HPoint hPoint2 = kDNode.k;
        double d2 = HPoint.sqrdist(hPoint2, hPoint);
        HRect hRect4 = hRect;
        HRect hRect5 = (HRect)hRect.clone();
        hRect4.max.coord[n3] = hPoint2.coord[n3];
        hRect5.min.coord[n3] = hPoint2.coord[n3];
        boolean bl2 = bl = hPoint.coord[n3] < hPoint2.coord[n3];
        if (bl) {
            kDNode3 = kDNode.left;
            hRect3 = hRect4;
            kDNode2 = kDNode.right;
            hRect2 = hRect5;
        } else {
            kDNode3 = kDNode.right;
            hRect3 = hRect5;
            kDNode2 = kDNode.left;
            hRect2 = hRect4;
        }
        KDNode.nnbr(kDNode3, hPoint, hRect3, d, n + 1, n2, nearestNeighborList, checker, l);
        KDNode<T> kDNode4 = nearestNeighborList.getHighest();
        double d3 = !nearestNeighborList.isCapacityReached() ? Double.MAX_VALUE : nearestNeighborList.getMaxPriority();
        d = Math.min(d, d3);
        HPoint hPoint3 = hRect2.closest(hPoint);
        if (HPoint.sqrdist(hPoint3, hPoint) < d) {
            if (d2 < d3) {
                kDNode4 = kDNode;
                d3 = d2;
                if (!kDNode.deleted && (checker == null || checker.usable(kDNode.v))) {
                    nearestNeighborList.insert(kDNode, d3);
                }
                d = nearestNeighborList.isCapacityReached() ? nearestNeighborList.getMaxPriority() : Double.MAX_VALUE;
            }
            KDNode.nnbr(kDNode2, hPoint, hRect2, d, n + 1, n2, nearestNeighborList, checker, l);
        }
    }

    private KDNode(HPoint hPoint, T t) {
        this.k = hPoint;
        this.v = t;
        this.left = null;
        this.right = null;
        this.deleted = false;
    }

    protected String toString(int n) {
        String string = this.k + "  " + this.v + (this.deleted ? "*" : "");
        if (this.left != null) {
            string = string + "\n" + KDNode.pad(n) + "L " + this.left.toString(n + 1);
        }
        if (this.right != null) {
            string = string + "\n" + KDNode.pad(n) + "R " + this.right.toString(n + 1);
        }
        return string;
    }

    private static String pad(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    private static void hrcopy(HRect hRect, HRect hRect2) {
        KDNode.hpcopy(hRect.min, hRect2.min);
        KDNode.hpcopy(hRect.max, hRect2.max);
    }

    private static void hpcopy(HPoint hPoint, HPoint hPoint2) {
        for (int i = 0; i < hPoint2.coord.length; ++i) {
            hPoint2.coord[i] = hPoint.coord[i];
        }
    }
}

