/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.kdtree;

import java.util.PriorityQueue;

class NearestNeighborList<T> {
    PriorityQueue<NeighborEntry<T>> m_Queue;
    int m_Capacity = 0;

    public NearestNeighborList(int n) {
        this.m_Capacity = n;
        this.m_Queue = new PriorityQueue(this.m_Capacity);
    }

    public double getMaxPriority() {
        NeighborEntry<T> neighborEntry = this.m_Queue.peek();
        return neighborEntry == null ? Double.POSITIVE_INFINITY : neighborEntry.value;
    }

    public boolean insert(T t, double d) {
        if (this.isCapacityReached()) {
            if (d > this.getMaxPriority()) {
                return false;
            }
            this.m_Queue.add(new NeighborEntry<T>(t, d));
            this.m_Queue.poll();
        } else {
            this.m_Queue.add(new NeighborEntry<T>(t, d));
        }
        return true;
    }

    public boolean isCapacityReached() {
        return this.m_Queue.size() >= this.m_Capacity;
    }

    public T getHighest() {
        NeighborEntry<T> neighborEntry = this.m_Queue.peek();
        return neighborEntry == null ? null : (T)neighborEntry.data;
    }

    public boolean isEmpty() {
        return this.m_Queue.size() == 0;
    }

    public int getSize() {
        return this.m_Queue.size();
    }

    public T removeHighest() {
        NeighborEntry<T> neighborEntry = this.m_Queue.poll();
        return neighborEntry == null ? null : (T)neighborEntry.data;
    }

    static class NeighborEntry<T>
    implements Comparable<NeighborEntry<T>> {
        final T data;
        final double value;

        public NeighborEntry(T t, double d) {
            this.data = t;
            this.value = d;
        }

        @Override
        public int compareTo(NeighborEntry<T> neighborEntry) {
            return Double.compare(neighborEntry.value, this.value);
        }
    }
}

