/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation;

import br.com.etyllica.animation.AnimationExecution;
import br.com.etyllica.animation.scripts.AnimationScript;
import br.com.etyllica.core.Updatable;
import java.util.ArrayList;
import java.util.List;

public class AnimationHandler
implements Updatable {
    private static AnimationHandler instance;
    private List<AnimationExecution> scripts = new ArrayList<AnimationExecution>();
    private List<AnimationScript> nextScripts = new ArrayList<AnimationScript>();

    private AnimationHandler() {
    }

    public static AnimationHandler getInstance() {
        if (instance == null) {
            instance = new AnimationHandler();
        }
        return instance;
    }

    @Override
    public void update(long l) {
        for (int i = this.scripts.size() - 1; i >= 0; --i) {
            AnimationExecution object = this.scripts.get(i);
            if (object.execute(l) || !this.repeatLogic(object, l)) continue;
            this.scripts.remove(object);
        }
        for (AnimationScript animationScript : this.nextScripts) {
            this.scripts.add(new AnimationExecution(animationScript));
        }
        this.nextScripts.clear();
    }

    private boolean repeatLogic(AnimationExecution animationExecution, long l) {
        AnimationScript animationScript = animationExecution.getScript();
        if (animationScript.getRepeat() == -1) {
            animationScript.restart();
            this.nextScripts.add(animationScript);
        } else {
            if (animationScript.getRepeat() - 1 > animationExecution.getRepeated()) {
                animationExecution.repeat();
                animationScript.preAnimate(l);
                return false;
            }
            this.notifyFinish(animationScript, l);
            this.appendNextScript(animationScript);
        }
        return true;
    }

    private void appendNextScript(AnimationScript animationScript) {
        AnimationScript animationScript2 = animationScript.getNext();
        if (animationScript2 != null) {
            this.nextScripts.add(animationScript2);
            animationScript2.restart();
        }
    }

    private void notifyFinish(AnimationScript animationScript, long l) {
        animationScript.finish(l);
    }

    public void add(AnimationScript animationScript) {
        this.scripts.add(new AnimationExecution(animationScript));
    }
}

