/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.pivot;

import br.com.etyllica.animation.pivot.Part;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.linear.vector.Vector2D;
import java.util.ArrayList;
import java.util.List;

public class PivotPoint
extends Vector2D {
    private List<Part> parts = new ArrayList<Part>();

    public PivotPoint(int n, int n2) {
        super(n, n2);
    }

    public void addPart(Part part) {
        this.linkPart(part);
        this.parts.add(part);
    }

    private void linkPart(Part part) {
        float f = part.getX() + part.getXPivot();
        float f2 = part.getY() + part.getYPivot();
        int n = (int)(this.x - (double)f);
        int n2 = (int)(this.y - (double)f2);
        part.setOffset(n, n2);
    }

    @Override
    public void setX(double d) {
        this.x = d;
        for (Part part : this.parts) {
            float f = part.getX() + part.getXPivot();
            int n = (int)(d - (double)f);
            part.setOffsetX(n);
        }
    }

    @Override
    public void setY(double d) {
        this.y = d;
        for (Part part : this.parts) {
            float f = part.getY() + part.getYPivot();
            int n = (int)(d - (double)f);
            part.setOffsetY(n);
        }
    }

    public void drawPart(Graphic graphic) {
        for (Part part : this.parts) {
            part.draw(graphic);
        }
    }

    public void rotate(double d, double d2, double d3) {
        double d4 = this.x - d;
        double d5 = this.y - d2;
        double d6 = Math.cos(Math.toRadians(d3));
        double d7 = Math.sin(Math.toRadians(d3));
        double d8 = d4 * d6 - d5 * d7 + d;
        double d9 = d4 * d7 + d5 * d6 + d2;
        for (Part part : this.parts) {
            this.linkPart(part);
            part.setOffset((int)(d8 - this.x), (int)(d9 - this.y));
            part.rotateByParent(d3);
        }
        this.x = d8;
        this.y = d9;
    }

    public List<Part> getParts() {
        return this.parts;
    }
}

