/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.scripts;

import br.com.etyllica.animation.scripts.SingleIntervalAnimation;
import br.com.etyllica.layer.Layer;

public class OrbitAnimation
extends SingleIntervalAnimation {
    private float centerX = 0.0f;
    private float centerY = 0.0f;
    private float tx;
    private float ty;
    private float tw;
    private float th;

    public OrbitAnimation(long l) {
        super(l);
    }

    public OrbitAnimation(long l, long l2) {
        super(l, l2);
    }

    public OrbitAnimation(Layer layer, long l) {
        super(layer, l);
    }

    public void setCenter(float f, float f2) {
        this.centerX = f;
        this.centerY = f2;
    }

    @Override
    public void setTarget(Layer layer) {
        super.setTarget(layer);
        this.tx = layer.getX();
        this.ty = layer.getY();
        this.tw = layer.getW() / 2;
        this.th = layer.getH() / 2;
    }

    @Override
    public void update(double d) {
        double d2 = d * Math.PI / 180.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        float f = this.tx + this.tw - this.centerX;
        float f2 = this.ty + this.th - this.centerY;
        double d5 = (double)f * d4 - (double)f2 * d3;
        double d6 = (double)f * d3 + (double)f2 * d4;
        this.target.setX((int)(d5 + (double)this.centerX - (double)this.tw));
        this.target.setY((int)(d6 + (double)this.centerY - (double)this.th));
    }
}

