/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.animation.transformation;

import java.awt.geom.AffineTransform;

public class Transform {
    private double x = 0.0;
    private double y = 0.0;
    private double angle = 0.0;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private boolean flip = false;

    public Transform() {
    }

    public Transform(double d) {
        this.angle = d;
    }

    public Transform(Transform transform) {
        this.copy(transform);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public void offsetAngle(double d) {
        this.angle += d;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void offsetX(double d) {
        this.x += d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void offsetY(double d) {
        this.y += d;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public void setFlip(boolean bl) {
        this.flip = bl;
    }

    public void copy(Transform transform) {
        this.x = transform.x;
        this.y = transform.y;
        this.angle = transform.angle;
        this.scaleX = transform.scaleX;
        this.scaleY = transform.scaleY;
        this.flip = transform.flip;
    }

    public AffineTransform getIncompleteTransform(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        affineTransform.concatenate(AffineTransform.getRotateInstance(this.angle, d, d2));
        return affineTransform;
    }

    public AffineTransform getTransformorm(double d, double d2) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.x, this.y);
        if (this.flip) {
            affineTransform.concatenate(AffineTransform.getScaleInstance(-this.scaleX, this.scaleY));
        } else {
            affineTransform.concatenate(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
        }
        affineTransform.concatenate(AffineTransform.getRotateInstance(this.angle, d, d2));
        return affineTransform;
    }
}

