/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.context;

import br.com.etyllica.animation.AnimationHandler;
import br.com.etyllica.animation.scripts.AnimationScript;
import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.layer.Layer;
import br.com.etyllica.particle.Emitter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Scene
implements Updatable {
    protected List<Updatable> updatables = new ArrayList<Updatable>();
    protected Map<Layer, List<Layer>> graph = new LinkedHashMap<Layer, List<Layer>>();

    public void addAnimation(AnimationScript animationScript) {
        AnimationHandler.getInstance().add(animationScript);
    }

    public void addEmitter(Emitter emitter) {
        this.updatables.add(emitter);
        this.add(emitter);
    }

    public void add(Layer layer) {
        this.graph.put(layer, new ArrayList());
    }

    public void addChild(Layer layer, Layer layer2) {
        if (!this.graph.containsKey(layer)) {
            this.add(layer);
        }
        List<Layer> list = this.graph.get(layer);
        list.add(layer2);
    }

    public Map<Layer, List<Layer>> getGraph() {
        return this.graph;
    }

    @Override
    public void update(long l) {
        for (Updatable updatable : this.updatables) {
            updatable.update(l);
        }
    }

    public void draw(Graphic graphic) {
        for (Layer layer : this.graph.keySet()) {
            this.drawLayer(graphic, layer);
        }
    }

    private void drawLayer(Graphic graphic, Layer layer) {
        layer.draw(graphic);
        List<Layer> list = this.graph.get(layer);
        for (Layer layer2 : list) {
            this.drawLayer(graphic, layer2);
        }
    }
}

