/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.event;

import br.com.etyllica.core.event.PointerState;
import br.com.etyllica.core.input.mouse.MouseButton;

public class PointerEvent {
    private MouseButton key;
    private PointerState state;
    private int x = 0;
    private int y = 0;
    private int amountX = 0;
    private int amountY = 0;
    private boolean consumed = false;
    private long timestamp = System.currentTimeMillis();

    public PointerEvent() {
    }

    public PointerEvent(MouseButton mouseButton, PointerState pointerState) {
        this.set(mouseButton, pointerState);
    }

    public PointerEvent(MouseButton mouseButton, PointerState pointerState, int n, int n2) {
        this.key = mouseButton;
        this.state = pointerState;
        this.x = n;
        this.y = n2;
        this.amountY = 0;
    }

    public PointerEvent(MouseButton mouseButton, PointerState pointerState, int n, int n2, int n3) {
        this.set(mouseButton, pointerState, n, n2, 0, n3);
    }

    public PointerEvent(MouseButton mouseButton, PointerState pointerState, int n, int n2, int n3, int n4) {
        this.set(mouseButton, pointerState, n, n2, n3, n4);
    }

    public void set(MouseButton mouseButton, PointerState pointerState) {
        this.set(mouseButton, pointerState, 0, 0);
    }

    public void set(MouseButton mouseButton, PointerState pointerState, int n, int n2) {
        this.set(mouseButton, pointerState, n, n2, 0, 0);
    }

    public void set(MouseButton mouseButton, PointerState pointerState, int n, int n2, int n3) {
        this.set(mouseButton, pointerState, n, n2, 0, n3);
    }

    public void set(MouseButton mouseButton, PointerState pointerState, int n, int n2, int n3, int n4) {
        this.key = mouseButton;
        this.state = pointerState;
        this.x = n;
        this.y = n2;
        this.amountX = n3;
        this.amountY = n4;
        this.consumed = false;
    }

    public void copy(PointerEvent pointerEvent) {
        this.set(pointerEvent.key, pointerEvent.state, pointerEvent.x, pointerEvent.y, pointerEvent.amountX, pointerEvent.amountY);
    }

    public MouseButton getKey() {
        return this.key;
    }

    public PointerState getState() {
        return this.state;
    }

    public void setState(PointerState pointerState) {
        this.state = pointerState;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getAmount() {
        return this.amountY;
    }

    public int getAmountX() {
        return this.amountX;
    }

    public int getAmountY() {
        return this.amountY;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isKey(MouseButton mouseButton) {
        return this.key == mouseButton;
    }

    public boolean isDraggedButton(MouseButton mouseButton) {
        if (this.consumed) {
            return false;
        }
        return this.state == PointerState.DRAGGED && this.key == mouseButton;
    }

    public boolean isButtonDown(MouseButton mouseButton) {
        if (this.consumed) {
            return false;
        }
        return (this.state == PointerState.PRESSED || this.state == PointerState.DRAGGED) && this.key == mouseButton;
    }

    public boolean isClicked(MouseButton mouseButton) {
        if (this.consumed) {
            return false;
        }
        return this.state == PointerState.CLICK && this.key == mouseButton;
    }

    public boolean isClicked() {
        if (this.consumed) {
            return false;
        }
        return this.state == PointerState.CLICK;
    }

    public boolean isButtonUp(MouseButton mouseButton) {
        if (this.consumed) {
            return false;
        }
        return this.state == PointerState.RELEASED && this.key == mouseButton;
    }
}

