/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.input.joystick;

import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.KeyState;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Joystick {
    private int id;
    private int lastXEvent = 1054;
    private int lastYEvent = 1055;
    private List<KeyEvent> list;
    private FileInputStream inputStream;
    private static final int JS_EVENT_BUTTON = 1;
    private static final int JS_EVENT_AXIS = 2;
    private static final int JS_EVENT_INIT = 128;
    public static final int MAX_AXIS_MOVEMENT = Short.MAX_VALUE;
    public static final int MIN_AXIS_MOVEMENT = -32767;
    private static final String JOYSTICK_DIRECTORY = "/dev/input/js";

    public Joystick(int n) throws FileNotFoundException {
        this.id = n;
        this.inputStream = new FileInputStream(JOYSTICK_DIRECTORY + n);
        this.list = new ArrayList<KeyEvent>();
    }

    public FileInputStream getInputStream() {
        return this.inputStream;
    }

    public List<KeyEvent> listen() {
        if (!this.list.isEmpty()) {
            this.list.clear();
        }
        byte[] byArray = new byte[8];
        int n = 0;
        try {
            n = this.inputStream.read(byArray, 0, 8);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.readFromBuffer(byArray, n);
        return this.list;
    }

    private void readFromBuffer(byte[] byArray, int n) {
        if (n == 8) {
            long l = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            int n2 = byArray[5] << 8 | byArray[4] & 0xFF;
            int n3 = byArray[6] & 0xFF;
            int n4 = byArray[7] & 0xFF;
            if (n3 == 2) {
                switch (n4) {
                    case 0: 
                    case 2: {
                        this.axisXEvent(l, n2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        this.axisYEvent(l, n2);
                        break;
                    }
                }
            } else if (n3 == 1) {
                this.buttonEvent(l, n2, n4);
            }
        } else {
            System.err.println("only " + n + " of 8 bytes read");
        }
    }

    private void buttonEvent(long l, int n, int n2) {
        int n3 = 1001 + n2;
        if (n == 1) {
            this.list.add(new KeyEvent(this.id, n3, 0, KeyState.PRESSED, l));
        } else {
            this.list.add(new KeyEvent(this.id, n3, 0, KeyState.RELEASED, l));
        }
    }

    private void axisYEvent(long l, int n) {
        if (n > 0) {
            this.lastYEvent = 1053;
            this.list.add(new KeyEvent(this.id, this.lastYEvent, n, KeyState.PRESSED, l));
        } else if (n < 0) {
            this.lastYEvent = 1052;
            this.list.add(new KeyEvent(this.id, this.lastYEvent, n, KeyState.PRESSED, l));
        } else {
            this.list.add(new KeyEvent(this.id, this.lastYEvent, n, KeyState.RELEASED, l));
            this.list.add(new KeyEvent(this.id, 1055, n, KeyState.RELEASED, l));
        }
    }

    private void axisXEvent(long l, int n) {
        if (n > 0) {
            this.lastXEvent = 1051;
            this.list.add(new KeyEvent(this.id, this.lastXEvent, n, KeyState.PRESSED, l));
        } else if (n < 0) {
            this.lastXEvent = 1050;
            this.list.add(new KeyEvent(this.id, this.lastXEvent, n, KeyState.PRESSED, l));
        } else {
            this.list.add(new KeyEvent(this.id, this.lastXEvent, n, KeyState.RELEASED, l));
            this.list.add(new KeyEvent(this.id, 1054, n, KeyState.RELEASED, l));
        }
    }
}

