/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader;

import br.com.etyllica.core.Updatable;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.input.InputKeyListener;
import br.com.etyllica.core.input.joystick.Joystick;
import br.com.etyllica.core.loader.LoaderImpl;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class JoystickLoader
extends LoaderImpl
implements Updatable,
Runnable {
    private static JoystickLoader instance = null;
    private boolean initialized = false;
    private InputKeyListener listener;
    private int updateDelay = 5;
    private int joysticks = 5;
    private List<KeyEvent> joystickEvents = new ArrayList<KeyEvent>();
    private Map<Integer, Joystick> inputStreams = new HashMap<Integer, Joystick>();
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;

    public static JoystickLoader getInstance() {
        if (instance == null) {
            instance = new JoystickLoader();
        }
        return instance;
    }

    public void init(int n) {
        this.joysticks = n;
        this.initLoader();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.future = this.executor.scheduleAtFixedRate(this, this.updateDelay, this.updateDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void initLoader() {
        int n;
        this.initialized = true;
        for (n = 0; n < this.joysticks; ++n) {
            try {
                this.inputStreams.put(n, new Joystick(n));
                System.out.println("Joystick " + n + " found!");
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Joystick " + n + " not found.");
                break;
            }
        }
        this.joysticks = n;
    }

    @Override
    public void run() {
        if (!this.initialized) {
            this.init(this.joysticks);
        }
        this.update(0L);
    }

    public List<KeyEvent> getJoyEvents() {
        return this.joystickEvents;
    }

    @Override
    public void update(long l) {
        for (Map.Entry<Integer, Joystick> entry : this.inputStreams.entrySet()) {
            this.listen(entry.getKey());
        }
        this.notifyListener();
    }

    private void notifyListener() {
        for (KeyEvent keyEvent : this.joystickEvents) {
            this.listener.updateJoystickEvent(keyEvent);
        }
        this.joystickEvents.clear();
    }

    private void listen(Integer n) {
        List<KeyEvent> list = this.inputStreams.get(n).listen();
        if (!list.isEmpty()) {
            this.joystickEvents.addAll(list);
        }
    }

    public InputKeyListener getListener() {
        return this.listener;
    }

    public void setListener(InputKeyListener inputKeyListener) {
        this.listener = inputKeyListener;
    }

    public ScheduledFuture<?> getFuture() {
        return this.future;
    }
}

