/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.core.loader.image;

import br.com.etyllica.core.loader.image.ImageReaderImpl;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PCXReader
extends ImageReaderImpl {
    private static PCXReader instance = null;

    public static PCXReader getInstance() {
        if (instance == null) {
            instance = new PCXReader();
        }
        return instance;
    }

    @Override
    public BufferedImage loadImage(URL uRL) throws IOException {
        int n;
        int[] nArray;
        int n2;
        InputStream inputStream = uRL.openStream();
        int n3 = inputStream.available();
        byte[] byArray = new byte[n3 + 1];
        byArray[n3] = 0;
        for (int i = 0; i < n3; ++i) {
            byArray[i] = (byte)inputStream.read();
        }
        inputStream.close();
        PCXHeader pCXHeader = new PCXHeader(byArray);
        byte[] byArray2 = pCXHeader.data;
        if (pCXHeader.manufacturer != '\n' || pCXHeader.version != '\u0005' || pCXHeader.encoding != '\u0001' || pCXHeader.bits_per_pixel != '\b' || pCXHeader.xmax >= 640 || pCXHeader.ymax >= 480) {
            System.err.println("Bad pcx file " + uRL);
            return null;
        }
        int[] nArray2 = new int[768];
        for (n2 = 0; n2 < 768; ++n2) {
            if (n3 - 128 - 768 + n2 >= pCXHeader.data.length) continue;
            nArray2[n2] = pCXHeader.data[n3 - 128 - 768 + n2] & 0xFF;
        }
        n2 = pCXHeader.xmax + 1;
        int n4 = pCXHeader.ymax + 1;
        int[] nArray3 = nArray = new int[(pCXHeader.ymax + 1) * (pCXHeader.xmax + 1)];
        int[] nArray4 = nArray;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 <= pCXHeader.ymax) {
            n = 0;
            while (n <= pCXHeader.xmax) {
                int n8;
                byte by;
                if (((by = byArray2[n6++]) & 0xC0) == 192) {
                    n8 = by & 0x3F;
                    by = byArray2[n6++];
                } else {
                    n8 = 1;
                }
                while (n8-- > 0) {
                    nArray4[n5 + n++] = by & 0xFF;
                }
            }
            ++n7;
            n5 += pCXHeader.xmax + 1;
        }
        if (nArray3 == null || nArray2 == null) {
            return null;
        }
        byte[] byArray3 = new byte[(n2 + 1) * (n4 + 1) * 3];
        for (n = 0; n < n2 * n4; ++n) {
            byArray3[n * 3] = (byte)nArray2[nArray3[n] * 3];
            byArray3[n * 3 + 1] = (byte)nArray2[nArray3[n] * 3 + 1];
            byArray3[n * 3 + 2] = (byte)nArray2[nArray3[n] * 3 + 2];
        }
        int[] nArray5 = new int[n2 * n4 * 3];
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray5[n9++] = 0xFF000000 | (byArray3[n10++] & 0xFF) << 16 | (byArray3[n10++] & 0xFF) << 8 | byArray3[n10++] & 0xFF;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        bufferedImage.setRGB(0, 0, n2, n4, nArray5, 0, n2);
        return bufferedImage;
    }

    private static class PCXHeader {
        private char manufacturer;
        private char version;
        private char encoding;
        private char bits_per_pixel;
        private short xmin;
        private short ymin;
        private short xmax;
        private short ymax;
        private short hres;
        private short vres;
        private int[] palette = new int[48];
        private char reserved;
        private char color_planes;
        private short bytes_per_line;
        private short palette_type;
        private byte[] filler = new byte[58];
        private byte[] data;

        PCXHeader(byte[] byArray) {
            int n;
            this.manufacturer = (char)byArray[0];
            this.version = (char)byArray[1];
            this.encoding = (char)byArray[2];
            this.bits_per_pixel = (char)byArray[3];
            this.xmin = (short)(byArray[4] + (byArray[5] << 8) & 0xFF);
            this.ymin = (short)(byArray[6] + (byArray[7] << 8) & 0xFF);
            this.xmax = (short)(byArray[8] + (byArray[9] << 8) & 0xFF);
            this.ymax = (short)(byArray[10] + (byArray[11] << 8) & 0xFF);
            this.hres = (short)(byArray[12] + (byArray[13] << 8) & 0xFF);
            this.vres = (short)(byArray[14] + (byArray[15] << 8) & 0xFF);
            for (n = 0; n < 48; ++n) {
                this.palette[n] = byArray[16 + n] & 0xFF;
            }
            this.reserved = (char)byArray[64];
            this.color_planes = (char)byArray[65];
            this.bytes_per_line = (short)(byArray[66] + (byArray[67] << 8) & 0xFF);
            this.palette_type = (short)(byArray[68] + (byArray[69] << 8) & 0xFF);
            for (n = 0; n < 58; ++n) {
                this.filler[n] = byArray[70 + n];
            }
            this.data = new byte[byArray.length - 128];
            for (n = 0; n < byArray.length - 128; ++n) {
                this.data[n] = byArray[128 + n];
            }
        }
    }
}

