/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.effects.light;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.effects.light.LightSpot;
import br.com.etyllica.layer.GeometricLayer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;

public class LightSource
extends GeometricLayer
implements LightSpot {
    private float[] fractions = new float[]{0.2f, 0.8f};
    private Color centerColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color borderColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private Color[] colors;
    private RadialGradientPaint rgp;

    public LightSource(int n, int n2, int n3) {
        super(n, n2);
        this.w = n3;
        this.h = n3;
        this.resetColors();
    }

    public int getIntensity() {
        return this.w;
    }

    public void setIntensity(int n) {
        this.w = n;
        this.h = n;
    }

    @Override
    public void drawLight(Graphic graphic) {
        graphic.setComposite(AlphaComposite.getInstance(5, 1.0f));
        Point2D.Float float_ = new Point2D.Float(this.x + this.w / 2, this.y + this.h / 2);
        this.rgp = new RadialGradientPaint(float_, this.w / 2, this.fractions, this.colors);
        graphic.setPaint(this.rgp);
        graphic.fillOval(this.x, this.y, this.w, this.h);
    }

    private void resetColors() {
        this.colors = new Color[2];
        this.colors[0] = this.centerColor;
        this.colors[1] = this.borderColor;
    }

    public Color getCenterColor() {
        return this.centerColor;
    }

    public void setCenterColor(Color color) {
        this.centerColor = color;
        this.resetColors();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
        this.resetColors();
    }
}

