/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.core.event.GUIEvent;
import br.com.etyllica.core.event.KeyEvent;
import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.core.input.mouse.MouseButton;
import br.com.etyllica.gui.View;
import br.com.etyllica.gui.factory.DefaultButton;
import br.com.etyllica.theme.Theme;
import br.com.etyllica.theme.ThemeManager;

public class Slider
extends View {
    protected int minValue = 0;
    protected int maxValue = 255;
    protected int value = 0;
    protected DefaultButton button;

    public Slider(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.button = new DefaultButton(n, n2, n4 / 3, n4);
    }

    @Override
    public GUIEvent updateMouse(PointerEvent pointerEvent) {
        if (this.mouseOver && pointerEvent.isButtonDown(MouseButton.MOUSE_BUTTON_LEFT)) {
            int n = this.maxValue - this.minValue;
            int n2 = pointerEvent.getX() - this.x;
            this.value = n2 * n / this.w;
            this.button.setX(pointerEvent.getX() - this.button.getW() / 2);
            return GUIEvent.COMPONENT_CHANGED;
        }
        return GUIEvent.NONE;
    }

    @Override
    public void update(GUIEvent gUIEvent) {
    }

    @Override
    public void draw(Graphic graphic) {
        Theme theme = ThemeManager.getInstance().getTheme();
        graphic.setColor(theme.getBarColor());
        graphic.fillRect(this.x, this.y + this.h / 3, this.w, this.h / 5);
        this.button.draw(graphic);
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        int n2 = this.maxValue - this.minValue;
        int n3 = this.x + n * this.w / n2;
        this.button.setX(n3 - this.button.getW() / 2);
    }

    @Override
    public GUIEvent updateKeyboard(KeyEvent keyEvent) {
        return GUIEvent.NONE;
    }
}

