/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui;

import br.com.etyllica.cinematics.Camera;
import br.com.etyllica.context.Context;
import br.com.etyllica.context.ContextContainer;
import br.com.etyllica.context.Session;
import br.com.etyllica.context.load.ApplicationLoader;
import br.com.etyllica.context.load.DefaultLoadApplication;
import br.com.etyllica.context.load.GenericLoadApplication;
import br.com.etyllica.layer.GeometricLayer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class Window
extends GeometricLayer
implements ContextContainer {
    protected Context application;
    protected List<Context> oldApplications = new ArrayList<Context>();
    protected Camera camera;
    protected Session session = new Session();
    protected ApplicationLoader applicationLoader;
    protected boolean close = false;
    private boolean loaded = true;
    private List<Window> windows = new ArrayList<Window>();
    protected DefaultLoadApplication loadApplication = null;

    public Window(int n, int n2) {
        this(0, 0, n, n2);
    }

    public Window(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.camera = new Camera(0, 0, n3, n4);
        this.applicationLoader = new ApplicationLoader();
        this.loadApplication = new GenericLoadApplication(n, n2, n3, n4);
        this.loadApplication.load();
    }

    public Rectangle getAsRectangle() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public void restartWindow() {
    }

    public void setApplication(Context context) {
        this.application = context;
    }

    public void setLoadApplication(DefaultLoadApplication defaultLoadApplication) {
        this.loadApplication = defaultLoadApplication;
        this.application = defaultLoadApplication;
    }

    public void reload(Context context) {
        if (this.loaded) {
            this.loaded = false;
            this.checkForLoadApplication(context);
            this.applicationLoader.setWindow(this);
            this.applicationLoader.setApplication(context);
            this.reloadLoadApplication();
        }
    }

    private void checkForLoadApplication(Context context) {
        DefaultLoadApplication defaultLoadApplication = context.getLoadApplication();
        if (defaultLoadApplication != null) {
            this.loadApplication = defaultLoadApplication;
        }
    }

    private void reloadLoadApplication() {
        this.loadApplication.load();
        this.setLoadApplication(this.loadApplication);
        this.applicationLoader.setLoadApplication(this.loadApplication);
        this.applicationLoader.loadApplication();
    }

    public void closeWindow() {
        this.setClose(true);
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean bl) {
        this.close = bl;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public List<Window> getWindows() {
        return this.windows;
    }

    public void setWindows(List<Window> list) {
        this.windows = list;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSessionMap(Session session) {
        this.session = session;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    @Override
    public Context getContext() {
        return this.application;
    }
}

