/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.gui.textfield;

import br.com.etyllica.gui.View;
import br.com.etyllica.gui.textfield.OnTextChangedListener;

public abstract class TextView
extends View {
    protected final int TEXT_BACKSPACE = 8;
    protected final int TEXT_TAB = 9;
    protected final int TEXT_ENTER = 10;
    protected final int TEXT_ESC = 27;
    protected final int TEXT_DELETE = 127;
    protected String text = "";
    protected int cursor = 0;
    protected int fixMark = -1;
    protected int minMark = 0;
    protected int maxMark = 0;
    protected int maxLength = 0;
    private OnTextChangedListener onTextChangeListener;

    public TextView(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.clearField();
    }

    public void clearField() {
        this.cursor = 0;
        this.fixMark = -1;
        this.minMark = 0;
        this.maxMark = 0;
        this.text = "";
        this.notifyTextChanged();
    }

    protected void leftNormal() {
        if (this.cursor > 0) {
            --this.cursor;
        }
    }

    protected void leftWithControl() {
        if (this.cursor > 0) {
            int n;
            for (n = this.cursor - 2; n > 0; --n) {
                if (this.text.charAt(n) != ' ') continue;
                ++n;
                break;
            }
            this.cursor = n;
        }
    }

    protected void rightWithControl() {
        int n;
        for (n = this.cursor + 1; n < this.text.length() && this.text.charAt(n) != ' '; ++n) {
        }
        this.cursor = n;
    }

    protected void rightNormal() {
        if (this.cursor < this.text.length()) {
            ++this.cursor;
        }
    }

    protected void eraseAsBackSpace() {
        if (this.fixMark == -1 && this.cursor > 0) {
            if (this.cursor < this.text.length()) {
                String string = this.text.substring(0, this.cursor - 1);
                String string2 = this.text.substring(this.cursor, this.text.length());
                this.text = string + string2;
            } else if (this.cursor > 0) {
                this.text = this.text.substring(0, this.cursor - 1);
            }
            this.leftNormal();
        } else {
            this.deleteMark();
        }
        this.notifyTextChanged();
    }

    protected void eraseAsDelete() {
        if (this.fixMark == -1) {
            if (this.cursor < this.text.length()) {
                String string = this.text.substring(0, this.cursor);
                String string2 = this.text.substring(this.cursor + 1, this.text.length());
                this.text = string + string2;
            }
        } else {
            this.deleteMark();
        }
        this.notifyTextChanged();
    }

    private void deleteMark() {
        String string = this.text.substring(0, this.getMinMark());
        String string2 = this.text.substring(this.getMaxMark(), this.text.length());
        this.text = string + string2;
        this.cursor = this.getMinMark();
        this.fixMark = -1;
    }

    protected void addChar(char c) {
        if (this.cursor < this.text.length()) {
            String string = this.text.substring(0, this.cursor);
            string = string + c;
            String string2 = this.text.substring(this.cursor, this.text.length());
            this.text = string + string2;
        } else {
            this.text = this.text + c;
        }
        this.fixMark = -1;
        ++this.cursor;
        this.notifyTextChanged();
    }

    protected int getMinMark() {
        if (this.fixMark < 0) {
            return 0;
        }
        if (this.cursor < this.fixMark) {
            return this.cursor;
        }
        return this.fixMark;
    }

    protected int getMaxMark() {
        if (this.fixMark < 0) {
            return 0;
        }
        if (this.cursor < this.fixMark) {
            return this.fixMark;
        }
        return this.cursor;
    }

    protected void moveCursorToStart() {
        this.cursor = 0;
    }

    protected void moveCursorToEnd() {
        this.cursor = this.text.length();
    }

    protected void notifyTextChanged() {
        if (this.onTextChangeListener == null) {
            return;
        }
    }

    public OnTextChangedListener getOnTextChangeListener() {
        return this.onTextChangeListener;
    }

    public void setOnTextChangeListener(OnTextChangedListener onTextChangedListener) {
        this.onTextChangeListener = onTextChangedListener;
    }
}

