/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.layer;

import br.com.etyllica.core.Movable;
import br.com.etyllica.linear.PointInt2D;

public class GeometricLayer
extends PointInt2D
implements Movable {
    protected int w = 0;
    protected int h = 0;

    public GeometricLayer() {
    }

    public GeometricLayer(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public GeometricLayer(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int n) {
        this.w = n;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int n) {
        this.h = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    @Override
    public void setCoordinates(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void setOffsetX(int n) {
        this.setX(this.x + n);
    }

    public void setOffsetY(int n) {
        this.setY(this.y + n);
    }

    public void setOffset(int n, int n2) {
        this.setOffsetX(n);
        this.setOffsetY(n2);
    }

    public void setSize(int n, int n2) {
        this.setW(n);
        this.setH(n2);
    }

    public void centralize(int n, int n2, int n3, int n4) {
        this.centralizeX(n, n + n3);
        this.centralizeY(n2, n2 + n4);
    }

    public void centralize(GeometricLayer geometricLayer) {
        this.centralizeX(geometricLayer);
        this.centralizeY(geometricLayer);
    }

    public void centralizeX(GeometricLayer geometricLayer) {
        this.centralizeX(geometricLayer.getX(), geometricLayer.getX() + geometricLayer.utilWidth());
    }

    public int centralizeX(int n, int n2) {
        int n3 = (n + n2) / 2 - this.utilWidth() / 2;
        this.setX(n3);
        return n3;
    }

    public void centralizeY(GeometricLayer geometricLayer) {
        this.centralizeY(geometricLayer.getY(), geometricLayer.getY() + geometricLayer.utilHeight());
    }

    public int centralizeY(int n, int n2) {
        int n3 = (n + n2) / 2 - this.utilHeight() / 2;
        this.setY(n3);
        return n3;
    }

    public void copy(GeometricLayer geometricLayer) {
        this.setX(geometricLayer.getX());
        this.setY(geometricLayer.getY());
        this.setW(geometricLayer.getW());
        this.setH(geometricLayer.getH());
    }

    public boolean colideRect(GeometricLayer geometricLayer) {
        if (geometricLayer.getX() + geometricLayer.utilWidth() < this.getX()) {
            return false;
        }
        if (geometricLayer.getX() > this.getX() + this.utilWidth()) {
            return false;
        }
        if (geometricLayer.getY() + geometricLayer.utilHeight() < this.getY()) {
            return false;
        }
        return geometricLayer.getY() <= this.getY() + this.utilHeight();
    }

    public boolean colideRect(int n, int n2, int n3, int n4) {
        if (n + n3 < this.getX()) {
            return false;
        }
        if (n > this.getX() + this.utilWidth()) {
            return false;
        }
        if (n2 + n4 < this.getY()) {
            return false;
        }
        return n2 <= this.getY() + this.utilHeight();
    }

    public boolean colideRectPoint(int n, int n2) {
        if (n + 1 < this.getX()) {
            return false;
        }
        if (n > this.getX() + this.utilWidth()) {
            return false;
        }
        if (n2 + 1 < this.getY()) {
            return false;
        }
        return n2 <= this.getY() + this.utilHeight();
    }

    public boolean colideCircleCircle(int n, int n2, int n3, int n4) {
        int n5 = n - this.x;
        int n6 = n2 - this.y;
        int n7 = n6 * n6 + n5 * n5;
        int n8 = n3 / 2 + this.w / 2;
        return n7 - (n8 *= n8) <= 0;
    }

    public boolean colideCircular(GeometricLayer geometricLayer) {
        int n = geometricLayer.getX() - this.x;
        int n2 = geometricLayer.getY() - this.y;
        int n3 = n2 * n2 + n * n;
        int n4 = geometricLayer.utilWidth() / 2 + this.utilWidth() / 2;
        return n3 - (n4 *= n4) <= 0;
    }

    public boolean colideCirclePoint(int n, int n2) {
        int n3 = this.x + this.w / 2;
        int n4 = this.y + this.h / 2;
        int n5 = (n - n3) * (n - n3);
        int n6 = (n2 - n4) * (n2 - n4);
        int n7 = this.w / 2;
        double d = Math.sqrt(n5 + n6);
        return d <= (double)n7;
    }

    public int utilWidth() {
        return this.getW();
    }

    public int utilHeight() {
        return this.getH();
    }
}

