/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.linear.graph;

import br.com.etyllica.linear.Point2D;
import br.com.etyllica.linear.graph.GenericEdge;
import br.com.etyllica.linear.graph.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class GenericComplexGraph<N, E extends GenericEdge<N>> {
    protected Set<E> edges;
    protected Set<Node<N>> nodes = new LinkedHashSet<Node<N>>();
    protected Map<Node<N>, List<E>> edgesByNodes;

    public GenericComplexGraph() {
        this.edges = new LinkedHashSet();
        this.edgesByNodes = new HashMap<Node<N>, List<E>>();
    }

    public Set<Node<N>> getNodes() {
        return this.nodes;
    }

    public void setNodes(Set<Node<N>> set) {
        this.nodes = set;
    }

    public void addNode(Node<N> node) {
        this.nodes.add(node);
    }

    public void addNode(Point2D point2D) {
        Node node = new Node();
        node.setLocation(point2D.getX(), point2D.getY());
        this.nodes.add(node);
    }

    public Map<Node<N>, List<E>> getAllEdges() {
        return this.edgesByNodes;
    }

    public List<E> getAllEdgesAsList() {
        ArrayList<E> arrayList = new ArrayList<E>();
        for (List<E> list : this.edgesByNodes.values()) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public Set<E> getEdges() {
        return this.edges;
    }

    public List<E> getEdges(Node<N> node) {
        if (this.edgesByNodes.containsKey(node)) {
            return this.edgesByNodes.get(node);
        }
        return new ArrayList();
    }

    public void addEdge(E e) {
        List<E> list;
        this.edges.add(e);
        this.addNodesFromEdge((GenericEdge<N>)e);
        Node node = ((GenericEdge)e).getOrigin();
        if (!this.edgesByNodes.containsKey(node)) {
            this.edgesByNodes.put(node, new ArrayList());
        }
        if (!(list = this.edgesByNodes.get(node)).contains(e)) {
            this.edgesByNodes.get(node).add(0, e);
        }
    }

    private void addNodesFromEdge(GenericEdge<N> genericEdge) {
        Node<N> node;
        Node<N> node2 = genericEdge.getOrigin();
        if (!this.nodes.contains(node2)) {
            this.nodes.add(node2);
        }
        if (!this.nodes.contains(node = genericEdge.getDestination())) {
            this.nodes.add(node);
        }
    }

    public boolean hasDiretionalEdge(Node<N> node, Node<N> node2) {
        for (GenericEdge genericEdge : this.edges) {
            if (genericEdge.getOrigin() != node || genericEdge.getDestination() != node2) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdge(Node<N> node, Node<N> node2) {
        for (GenericEdge genericEdge : this.edges) {
            if (genericEdge.getOrigin() == node && genericEdge.getDestination() == node2) {
                return true;
            }
            if (genericEdge.getDestination() != node || genericEdge.getOrigin() != node2) continue;
            return true;
        }
        return false;
    }

    public void mergeGraph(GenericComplexGraph<N, E> genericComplexGraph) {
        for (GenericEdge genericEdge : genericComplexGraph.edges) {
            this.addEdge(genericEdge);
        }
    }

    public void clear() {
        this.nodes.clear();
        this.edges.clear();
        this.edgesByNodes.clear();
    }
}

