/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.concurrency;

import br.com.etyllica.util.concurrency.ItemAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConcurrentSet<T> {
    private Set<T> set = new HashSet<T>();
    private Map<T, ItemAction> itemActions = new HashMap<T, ItemAction>();
    private boolean locked = false;

    public void add(T t) {
        if (!this.locked) {
            this.set.add(t);
        } else {
            this.itemActions.put(t, ItemAction.ADD_ITEM);
        }
    }

    public void remove(T t) {
        if (!this.locked) {
            this.set.remove(t);
        } else {
            this.itemActions.put(t, ItemAction.REMOVE_ITEM);
        }
    }

    public Set<T> lock() {
        this.locked = true;
        return this.set;
    }

    public void unlock() {
        this.locked = false;
        if (!this.itemActions.isEmpty()) {
            for (Map.Entry<T, ItemAction> entry : this.itemActions.entrySet()) {
                ItemAction itemAction = entry.getValue();
                if (ItemAction.ADD_ITEM.equals((Object)itemAction)) {
                    this.set.add(entry.getKey());
                    continue;
                }
                if (!ItemAction.REMOVE_ITEM.equals((Object)itemAction)) continue;
                this.set.remove(entry.getKey());
            }
            this.itemActions.clear();
        }
    }

    public Set<T> getSet() {
        return this.set;
    }
}

