/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.kdtree;

import br.com.etyllica.util.kdtree.HPoint;
import java.io.Serializable;

class HRect
implements Serializable {
    protected HPoint min;
    protected HPoint max;

    protected HRect(int n) {
        this.min = new HPoint(n);
        this.max = new HPoint(n);
    }

    protected HRect(HPoint hPoint, HPoint hPoint2) {
        this.min = (HPoint)hPoint.clone();
        this.max = (HPoint)hPoint2.clone();
    }

    protected Object clone() {
        return new HRect(this.min, this.max);
    }

    protected HPoint closest(HPoint hPoint) {
        HPoint hPoint2 = new HPoint(hPoint.coord.length);
        for (int i = 0; i < hPoint.coord.length; ++i) {
            hPoint2.coord[i] = hPoint.coord[i] <= this.min.coord[i] ? this.min.coord[i] : (hPoint.coord[i] >= this.max.coord[i] ? this.max.coord[i] : hPoint.coord[i]);
        }
        return hPoint2;
    }

    protected static HRect infiniteHRect(int n) {
        HPoint hPoint = new HPoint(n);
        HPoint hPoint2 = new HPoint(n);
        for (int i = 0; i < n; ++i) {
            hPoint.coord[i] = Double.NEGATIVE_INFINITY;
            hPoint2.coord[i] = Double.POSITIVE_INFINITY;
        }
        return new HRect(hPoint, hPoint2);
    }

    protected HRect intersection(HRect hRect) {
        HPoint hPoint = new HPoint(this.min.coord.length);
        HPoint hPoint2 = new HPoint(this.min.coord.length);
        for (int i = 0; i < this.min.coord.length; ++i) {
            hPoint.coord[i] = Math.max(this.min.coord[i], hRect.min.coord[i]);
            hPoint2.coord[i] = Math.min(this.max.coord[i], hRect.max.coord[i]);
            if (!(hPoint.coord[i] >= hPoint2.coord[i])) continue;
            return null;
        }
        return new HRect(hPoint, hPoint2);
    }

    protected double area() {
        double d = 1.0;
        for (int i = 0; i < this.min.coord.length; ++i) {
            d *= this.max.coord[i] - this.min.coord[i];
        }
        return d;
    }

    public String toString() {
        return this.min + "\n" + this.max + "\n";
    }
}

