/*
 * Decompiled with CFR 0.152.
 */
package br.com.etyllica.util.kdtree;

import br.com.etyllica.util.kdtree.Checker;
import br.com.etyllica.util.kdtree.DistanceMetric;
import br.com.etyllica.util.kdtree.Editor;
import br.com.etyllica.util.kdtree.EuclideanDistance;
import br.com.etyllica.util.kdtree.HPoint;
import br.com.etyllica.util.kdtree.HRect;
import br.com.etyllica.util.kdtree.HammingDistance;
import br.com.etyllica.util.kdtree.KDNode;
import br.com.etyllica.util.kdtree.KeyDuplicateException;
import br.com.etyllica.util.kdtree.KeyMissingException;
import br.com.etyllica.util.kdtree.KeySizeException;
import br.com.etyllica.util.kdtree.NearestNeighborList;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class KDTree<T>
implements Serializable {
    final long m_timeout;
    private final int m_K;
    private KDNode<T> m_root;
    private int m_count;

    public KDTree(int n) {
        this(n, 0L);
    }

    public KDTree(int n, long l) {
        this.m_timeout = l;
        this.m_K = n;
        this.m_root = null;
    }

    public void insert(double[] dArray, T t) throws KeySizeException, KeyDuplicateException {
        this.edit(dArray, new Editor.Inserter<T>(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit(double[] dArray, Editor<T> editor) throws KeySizeException, KeyDuplicateException {
        if (dArray.length != this.m_K) {
            throw new KeySizeException();
        }
        KDTree kDTree = this;
        synchronized (kDTree) {
            if (null == this.m_root) {
                this.m_root = KDNode.create(new HPoint(dArray), editor);
                this.m_count = this.m_root.deleted ? 0 : 1;
                return;
            }
        }
        this.m_count += KDNode.edit(new HPoint(dArray), editor, this.m_root, 0, this.m_K);
    }

    public T search(double[] dArray) throws KeySizeException {
        if (dArray.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode<T> kDNode = KDNode.srch(new HPoint(dArray), this.m_root, this.m_K);
        return kDNode == null ? null : (T)kDNode.v;
    }

    public void delete(double[] dArray) throws KeySizeException, KeyMissingException {
        this.delete(dArray, false);
    }

    public void delete(double[] dArray, boolean bl) throws KeySizeException, KeyMissingException {
        if (dArray.length != this.m_K) {
            throw new KeySizeException();
        }
        KDNode<T> kDNode = KDNode.srch(new HPoint(dArray), this.m_root, this.m_K);
        if (kDNode == null) {
            if (!bl) {
                throw new KeyMissingException();
            }
        } else if (KDNode.del(kDNode)) {
            --this.m_count;
        }
    }

    public T nearest(double[] dArray) throws KeySizeException {
        List<T> list = this.nearest(dArray, 1, null);
        return list.get(0);
    }

    public List<T> nearest(double[] dArray, int n) throws KeySizeException, IllegalArgumentException {
        return this.nearest(dArray, n, null);
    }

    public List<T> nearestEuclidean(double[] dArray, double d) throws KeySizeException {
        return this.nearestDistance(dArray, d, new EuclideanDistance());
    }

    public List<T> nearestHamming(double[] dArray, double d) throws KeySizeException {
        return this.nearestDistance(dArray, d, new HammingDistance());
    }

    public List<T> nearest(double[] dArray, int n, Checker<T> checker) throws KeySizeException, IllegalArgumentException {
        if (n <= 0) {
            return new LinkedList();
        }
        NearestNeighborList<KDNode<T>> nearestNeighborList = this.getnbrs(dArray, n, checker);
        n = nearestNeighborList.getSize();
        Stack stack = new Stack();
        for (int i = 0; i < n; ++i) {
            KDNode<T> kDNode = nearestNeighborList.removeHighest();
            stack.push(kDNode.v);
        }
        return stack;
    }

    public List<T> range(double[] dArray, double[] dArray2) throws KeySizeException {
        if (dArray.length != dArray2.length) {
            throw new KeySizeException();
        }
        if (dArray.length != this.m_K) {
            throw new KeySizeException();
        }
        LinkedList linkedList = new LinkedList();
        KDNode.rsearch(new HPoint(dArray), new HPoint(dArray2), this.m_root, 0, this.m_K, linkedList);
        LinkedList linkedList2 = new LinkedList();
        for (KDNode kDNode : linkedList) {
            linkedList2.add(kDNode.v);
        }
        return linkedList2;
    }

    public int size() {
        return this.m_count;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.m_root.toString(0);
    }

    private NearestNeighborList<KDNode<T>> getnbrs(double[] dArray) throws KeySizeException {
        return this.getnbrs(dArray, this.m_count, null);
    }

    private NearestNeighborList<KDNode<T>> getnbrs(double[] dArray, int n, Checker<T> checker) throws KeySizeException {
        if (dArray.length != this.m_K) {
            throw new KeySizeException();
        }
        NearestNeighborList<KDNode<T>> nearestNeighborList = new NearestNeighborList<KDNode<T>>(n);
        HRect hRect = HRect.infiniteHRect(dArray.length);
        double d = Double.MAX_VALUE;
        HPoint hPoint = new HPoint(dArray);
        if (this.m_count > 0) {
            long l = this.m_timeout > 0L ? System.currentTimeMillis() + this.m_timeout : 0L;
            KDNode.nnbr(this.m_root, hPoint, hRect, d, 0, this.m_K, nearestNeighborList, checker, l);
        }
        return nearestNeighborList;
    }

    private List<T> nearestDistance(double[] dArray, double d, DistanceMetric distanceMetric) throws KeySizeException {
        NearestNeighborList<KDNode<T>> nearestNeighborList = this.getnbrs(dArray);
        int n = nearestNeighborList.getSize();
        Stack stack = new Stack();
        for (int i = 0; i < n; ++i) {
            KDNode<T> kDNode = nearestNeighborList.removeHighest();
            HPoint hPoint = kDNode.k;
            if (!(distanceMetric.distance(hPoint.coord, dArray) < d)) continue;
            stack.push(kDNode.v);
        }
        return stack;
    }
}

