/*
 * Decompiled with CFR 0.152.
 */
package br.com.tide.input;

import br.com.etyllica.core.event.PointerEvent;
import br.com.etyllica.layer.GeometricLayer;
import br.com.tide.input.controller.Controller;
import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;

public class FirstPersonController
extends Controller {
    protected int turnLeftButton = 37;
    protected int turnRightButton = 39;
    protected int goForwardButton = 38;
    protected int goBackwardButton = 40;
    protected int MAX_UP_ANGLE = -45;
    protected int MIN_UP_ANGLE = 45;
    protected boolean invertedVertically = false;
    protected int sensitivity = 2;
    protected double angleX = 0.0;
    protected double angleY = 0.0;
    private boolean validY = true;
    private int lastValidY = 0;

    public void updateMouse(GeometricLayer geometricLayer, PointerEvent pointerEvent) {
        int n = pointerEvent.getX();
        int n2 = pointerEvent.getY();
        int n3 = this.invertedVertically ? -1 : 1;
        int n4 = geometricLayer.getW() / 2 - n;
        int n5 = geometricLayer.getH() / 2 - n2;
        Point point = MouseInfo.getPointerInfo().getLocation();
        this.angleY = n4 * this.sensitivity;
        this.updateMouseX(geometricLayer, point, n4);
        this.updateMouseY(geometricLayer, point, n5);
        this.angleX = n5 * this.sensitivity * n3;
    }

    protected boolean updateMouseX(GeometricLayer geometricLayer, Point point, double d) {
        int n = point.x;
        int n2 = point.y;
        boolean bl = false;
        if (d < -360.0) {
            int n3 = 360 + (int)d;
            n = geometricLayer.getX() + geometricLayer.getW() / 2 + n3;
            bl = true;
        } else if (d > 360.0) {
            int n4 = 360 - (int)d;
            n = geometricLayer.getX() + geometricLayer.getW() / 2 + n4;
            bl = true;
        }
        if (bl) {
            this.moveMouse(n, n2);
        }
        return bl;
    }

    protected boolean updateMouseY(GeometricLayer geometricLayer, Point point, double d) {
        int n = point.x;
        int n2 = point.y;
        boolean bl = false;
        if (d < (double)(-this.MAX_UP_ANGLE)) {
            bl = true;
            d = -this.MAX_UP_ANGLE;
            if (this.validY) {
                this.validY = false;
            }
        } else if (d > (double)this.MIN_UP_ANGLE) {
            bl = true;
            d = this.MIN_UP_ANGLE;
            if (this.validY) {
                this.validY = false;
            }
        } else {
            this.validY = true;
            this.lastValidY = n2;
        }
        if (bl) {
            this.moveMouse(n, this.lastValidY);
        }
        return bl;
    }

    private void moveMouse(int n, int n2) {
        try {
            Robot robot = new Robot();
            robot.mouseMove(n, n2);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    public double getAngleX() {
        return this.angleX;
    }

    public double getAngleY() {
        return this.angleY;
    }

    public boolean isInvertedVertically() {
        return this.invertedVertically;
    }

    public void setInvertedVertically(boolean bl) {
        this.invertedVertically = bl;
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(int n) {
        this.sensitivity = n;
    }
}

