/*
 * Decompiled with CFR 0.152.
 */
package br.com.tide.platform.player;

import br.com.tide.ActivePlayer;
import br.com.tide.PlayerState;
import br.com.tide.input.ControllerListener;
import br.com.tide.platform.player.PlatformPlayerListener;

public class PlatformPlayer
extends ActivePlayer
implements ControllerListener {
    protected int walkSpeed = 5;
    protected int runSpeed = 5;
    protected int jumpSpeed = 5;
    protected int jumpHeight = 64;
    protected int jumpStart = 0;
    protected PlatformPlayerListener listener;

    public PlatformPlayer() {
    }

    public PlatformPlayer(PlatformPlayerListener platformPlayerListener) {
        this.listener = platformPlayerListener;
    }

    @Override
    public void update(long l) {
        super.update(l);
        if (this.hasState(PlayerState.WALK_LEFT)) {
            this.x -= this.currentSpeed;
        } else if (this.hasState(PlayerState.WALK_RIGHT)) {
            this.x += this.currentSpeed;
        }
        if (this.hasState(PlayerState.JUMP, PlayerState.FALL)) {
            this.updateJump();
        }
    }

    protected void updateJump() {
        if (!this.hasState(PlayerState.FALL)) {
            if (this.y > this.jumpStart - this.jumpHeight) {
                this.y -= this.jumpSpeed;
            } else {
                this.y = this.jumpStart - this.jumpHeight;
                this.fall();
            }
        } else {
            this.y += this.jumpSpeed;
        }
    }

    public void walkLeft() {
        if (!this.states.contains((Object)PlayerState.TURN_LEFT)) {
            this.listener.onTurnLeft(this);
            this.states.add(PlayerState.TURN_LEFT);
            this.states.remove((Object)PlayerState.TURN_RIGHT);
        }
        this.listener.onWalkLeft(this);
        this.states.add(PlayerState.WALK_LEFT);
    }

    public void stopWalkLeft() {
        this.states.remove((Object)PlayerState.WALK_LEFT);
        this.listener.onStopWalkLeft(this);
    }

    public void walkRight() {
        if (!this.states.contains((Object)PlayerState.TURN_RIGHT)) {
            this.listener.onTurnRight(this);
            this.states.add(PlayerState.TURN_RIGHT);
            this.states.remove((Object)PlayerState.TURN_LEFT);
        }
        this.listener.onWalkRight(this);
        this.states.add(PlayerState.WALK_RIGHT);
    }

    public void stopWalkRight() {
        this.states.remove((Object)PlayerState.WALK_RIGHT);
        this.listener.onStopWalkRight(this);
    }

    public void lookUp() {
        if (this.isWalking()) {
            this.stopWalk();
        }
        this.listener.onLookUp(this);
        this.states.add(PlayerState.LOOK_UP);
    }

    public void turnLeft() {
    }

    public void turnRight() {
    }

    public void stopWalkUp() {
        this.states.remove((Object)PlayerState.WALK_UP);
        this.listener.onStopLookUp(this);
    }

    public void standDown() {
        this.listener.onStandDown(this);
        this.states.add(PlayerState.STAND_DOWN);
    }

    public void stopStandDown() {
        this.states.remove((Object)PlayerState.STAND_DOWN);
        this.listener.onStopStandDown(this);
    }

    public void stopWalk() {
        this.states.remove((Object)PlayerState.WALK_LEFT);
        this.states.remove((Object)PlayerState.WALK_RIGHT);
    }

    public void jump() {
        this.jumpStart = this.y;
        this.listener.onJump(this);
        this.states.add(PlayerState.JUMP);
    }

    public void fall() {
        this.states.add(PlayerState.FALL);
    }

    public void fall(int n) {
        this.states.add(PlayerState.FALL);
    }

    public void stopJump() {
        this.states.remove((Object)PlayerState.FALL);
        this.states.remove((Object)PlayerState.JUMP);
    }

    public void run() {
        this.currentSpeed = this.runSpeed;
        this.listener.onRun(this);
    }

    public void stopRun() {
        this.currentSpeed = this.walkSpeed;
        this.listener.onStopRun(this);
    }

    public boolean isWalking() {
        return this.hasState(PlayerState.WALK_RIGHT, PlayerState.WALK_LEFT, PlayerState.WALK_UP, PlayerState.WALK_DOWN);
    }

    public boolean isJumping() {
        return this.states.contains((Object)PlayerState.JUMP);
    }

    public boolean isFalling() {
        return this.states.contains((Object)PlayerState.FALL);
    }

    public void lookUpAction() {
    }

    public void standDownAction() {
    }

    @Override
    public void onUpButtonPressed() {
        this.lookUp();
    }

    @Override
    public void onUpButtonReleased() {
        this.stopWalkUp();
    }

    @Override
    public void onDownButtonPressed() {
        this.standDown();
    }

    @Override
    public void onDownButtonReleased() {
        this.stopStandDown();
    }

    @Override
    public void onRightButtonPressed() {
        this.walkRight();
    }

    @Override
    public void onRightButtonReleased() {
        this.stopWalkRight();
    }

    @Override
    public void onLeftButtonPressed() {
        this.walkLeft();
    }

    @Override
    public void onLeftButtonReleased() {
        this.stopWalkLeft();
    }

    @Override
    public void onAButtonPressed() {
        this.run();
    }

    @Override
    public void onAButtonReleased() {
        this.stopRun();
    }

    @Override
    public void onBButtonPressed() {
        this.jump();
    }

    @Override
    public void onBButtonReleased() {
    }

    @Override
    public void onCButtonPressed() {
        this.attack();
    }

    @Override
    public void onCButtonReleased() {
        this.stopAttack();
        this.stand();
    }

    @Override
    public void onXButtonPressed() {
        this.specialAttack();
    }

    @Override
    public void onXButtonReleased() {
        this.onStopSpecialAttack();
        this.stand();
    }

    @Override
    public void onYButtonPressed() {
        this.run();
    }

    @Override
    public void onYButtonReleased() {
        this.stopRun();
    }

    @Override
    public void onZButtonPressed() {
    }

    @Override
    public void onZButtonReleased() {
    }
}

