/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dyn4j.resources.Messages;

public class BinarySearchTree<E extends Comparable<E>>
implements Iterable<E> {
    protected Node root;
    protected int size;
    protected boolean selfBalancing = true;

    public BinarySearchTree() {
        this.root = null;
        this.size = 0;
        this.selfBalancing = false;
    }

    public BinarySearchTree(boolean bl) {
        this.root = null;
        this.size = 0;
        this.selfBalancing = bl;
    }

    public BinarySearchTree(BinarySearchTree<E> binarySearchTree) {
        this.selfBalancing = binarySearchTree.selfBalancing;
        this.insertSubtree(binarySearchTree);
    }

    public BinarySearchTree(BinarySearchTree<E> binarySearchTree, boolean bl) {
        this.selfBalancing = bl;
        this.insertSubtree(binarySearchTree);
    }

    public boolean isSelfBalancing() {
        return this.selfBalancing;
    }

    public void setSelfBalancing(boolean bl) {
        if (bl && !this.selfBalancing) {
            this.selfBalancing = true;
            if (this.size > 2) {
                this.balanceTree();
            }
        }
        this.selfBalancing = bl;
    }

    public boolean insert(E e) {
        if (e == null) {
            return false;
        }
        Node node = new Node(this, e);
        this.insert(node);
        return true;
    }

    public boolean remove(E e) {
        if (e == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        Node node = this.remove(e, this.root);
        return node != null;
    }

    public E removeMinimum() {
        if (this.root == null) {
            return null;
        }
        return this.removeMinimum((Node)this.root).comparable;
    }

    public E removeMaximum() {
        if (this.root == null) {
            return null;
        }
        return this.removeMaximum((Node)this.root).comparable;
    }

    public E getMinimum() {
        if (this.root == null) {
            return null;
        }
        return this.getMinimum((Node)this.root).comparable;
    }

    public E getMaximum() {
        if (this.root == null) {
            return null;
        }
        return this.getMaximum((Node)this.root).comparable;
    }

    public boolean contains(E e) {
        if (e == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        Node node = this.contains(this.root, e);
        return node != null;
    }

    public E getRoot() {
        if (this.root == null) {
            return null;
        }
        return this.root.comparable;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int getHeight() {
        return this.getHeight(this.root);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.inOrderIterator();
    }

    public Iterator<E> inOrderIterator() {
        return new TreeIterator(this.root, Direction.ASCENDING);
    }

    public Iterator<E> reverseOrderIterator() {
        return new TreeIterator(this.root, Direction.DESCENDING);
    }

    protected Node getMinimum(Node node) {
        if (node == null) {
            return null;
        }
        while (node.left != null) {
            node = node.left;
        }
        return node;
    }

    protected Node getMaximum(Node node) {
        if (node == null) {
            return null;
        }
        while (node.right != null) {
            node = node.right;
        }
        return node;
    }

    protected Node getRootNode() {
        return this.root;
    }

    protected Node removeMinimum(Node node) {
        if ((node = this.getMinimum(node)) == null) {
            return null;
        }
        if (node == this.root) {
            this.root = node.right;
        } else if (node.parent.right == node) {
            node.parent.right = node.right;
        } else {
            node.parent.left = node.right;
        }
        --this.size;
        return node;
    }

    protected Node removeMaximum(Node node) {
        if ((node = this.getMaximum(node)) == null) {
            return null;
        }
        if (node == this.root) {
            this.root = node.left;
        } else if (node.parent.right == node) {
            node.parent.right = node.left;
        } else {
            node.parent.left = node.left;
        }
        --this.size;
        return node;
    }

    protected int getHeight(Node node) {
        if (node == null) {
            return 0;
        }
        if (node.left == null && node.right == null) {
            return 1;
        }
        return 1 + Math.max(this.getHeight(node.left), this.getHeight(node.right));
    }

    protected int size(Node node) {
        if (node == null) {
            return 0;
        }
        if (node.left == null && node.right == null) {
            return 1;
        }
        return 1 + this.size(node.left) + this.size(node.right);
    }

    protected boolean contains(Node node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (node == this.root) {
            return true;
        }
        Node node2 = this.root;
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            int n = node.comparable.compareTo(node2.comparable);
            if (n == 0) {
                return false;
            }
            if (n < 0) {
                node2 = node2.left;
                continue;
            }
            node2 = node2.right;
        }
        return false;
    }

    protected Node get(E e) {
        if (e == null) {
            return null;
        }
        if (this.root == null) {
            return null;
        }
        return this.contains(this.root, e);
    }

    protected boolean insertSubtree(Node node) {
        if (node == null) {
            return false;
        }
        TreeIterator treeIterator = new TreeIterator(node);
        while (treeIterator.hasNext()) {
            Node node2 = new Node(this, (Comparable)treeIterator.next());
            this.insert(node2);
        }
        return true;
    }

    protected boolean insertSubtree(BinarySearchTree<E> binarySearchTree) {
        if (binarySearchTree == null) {
            return false;
        }
        if (binarySearchTree.root == null) {
            return true;
        }
        Iterator<E> iterator = binarySearchTree.inOrderIterator();
        while (iterator.hasNext()) {
            Node node = new Node(this, (Comparable)iterator.next());
            this.insert(node);
        }
        return true;
    }

    protected boolean removeSubtree(E e) {
        if (e == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        Node node = this.root;
        while (node != null) {
            int n = e.compareTo(node.comparable);
            if (n < 0) {
                node = node.left;
                continue;
            }
            if (n > 0) {
                node = node.right;
                continue;
            }
            if (node.isLeftChild()) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            this.size -= this.size(node);
            if (this.selfBalancing) {
                this.balanceTree(node.parent);
            }
            return true;
        }
        return false;
    }

    protected boolean removeSubtree(Node node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (this.root == node) {
            this.root = null;
        } else if (this.contains(node)) {
            if (node.isLeftChild()) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            this.size -= this.size(node);
            if (this.selfBalancing) {
                this.balanceTree(node.parent);
            }
            return true;
        }
        return false;
    }

    protected boolean insert(Node node) {
        if (this.root == null) {
            this.root = node;
            ++this.size;
            return true;
        }
        return this.insert(node, this.root);
    }

    protected boolean insert(Node node, Node node2) {
        if (node2 == null) {
            return false;
        }
        while (node2 != null) {
            if (node.comparable.compareTo(node2.comparable) < 0) {
                if (node2.left == null) {
                    node2.left = node;
                    node.parent = node2;
                    break;
                }
                node2 = node2.left;
                continue;
            }
            if (node2.right == null) {
                node2.right = node;
                node.parent = node2;
                break;
            }
            node2 = node2.right;
        }
        ++this.size;
        if (this.selfBalancing) {
            this.balanceTree(node2);
        }
        return true;
    }

    protected boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (this.contains(node)) {
            this.removeNode(node);
            return true;
        }
        return false;
    }

    protected Node remove(E e, Node node) {
        while (node != null) {
            int n = e.compareTo(node.comparable);
            if (n < 0) {
                node = node.left;
                continue;
            }
            if (n > 0) {
                node = node.right;
                continue;
            }
            this.removeNode(node);
            return node;
        }
        return null;
    }

    protected void removeNode(Node node) {
        boolean bl = node.isLeftChild();
        if (node.left != null && node.right != null) {
            Node node2 = this.getMinimum(node.right);
            if (node2 != node.right) {
                node2.parent.left = node2.right;
                if (node2.right != null) {
                    node2.right.parent = node2.parent;
                }
                node2.right = node.right;
            }
            if (node.right != null) {
                node.right.parent = node2;
            }
            if (node.left != null) {
                node.left.parent = node2;
            }
            if (node == this.root) {
                this.root = node2;
            } else if (bl) {
                node.parent.left = node2;
            } else {
                node.parent.right = node2;
            }
            node2.left = node.left;
            node2.parent = node.parent;
            if (this.selfBalancing) {
                this.balanceTree(node2.parent);
            }
        } else if (node.left != null) {
            if (node == this.root) {
                this.root = node.left;
            } else if (bl) {
                node.parent.left = node.left;
            } else {
                node.parent.right = node.left;
            }
            if (node.left != null) {
                node.left.parent = node.parent;
            }
        } else if (node.right != null) {
            if (node == this.root) {
                this.root = node.right;
            } else if (bl) {
                node.parent.left = node.right;
            } else {
                node.parent.right = node.right;
            }
            if (node.right != null) {
                node.right.parent = node.parent;
            }
        } else if (node == this.root) {
            this.root = null;
        } else if (bl) {
            node.parent.left = null;
        } else {
            node.parent.right = null;
        }
        --this.size;
    }

    protected Node contains(Node node, E e) {
        while (node != null) {
            Object e2 = node.comparable;
            int n = e.compareTo(e2);
            if (n == 0) {
                return node;
            }
            if (n < 0) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return null;
    }

    protected void balanceTree() {
        Node node = this.root;
        this.root = null;
        this.size = 0;
        TreeIterator treeIterator = new TreeIterator(node);
        while (treeIterator.hasNext()) {
            Node node2 = new Node(this, (Comparable)treeIterator.next());
            this.insert(node2);
        }
    }

    protected void balanceTree(Node node) {
        while (node != null) {
            node = this.balance(node);
            node = node.parent;
        }
    }

    protected Node balance(Node node) {
        int n;
        if (node == null) {
            return null;
        }
        if (this.getHeight(node) < 2) {
            return node;
        }
        Node node2 = node.parent;
        Node node3 = node.left;
        Node node4 = node.right;
        int n2 = this.getHeight(node3);
        int n3 = n2 - (n = this.getHeight(node4));
        if (n3 > 1) {
            Node node5;
            int n4 = this.getHeight(node3.right);
            if (n4 > 1) {
                node5 = node3.right;
                node3.right = node5.left;
                if (node5.left != null) {
                    node5.left.parent = node3;
                }
                node5.left = node3;
                node3.parent = node5;
                node.left = node5;
                node5.parent = node;
            }
            node5 = node.left;
            node.left = node5.right;
            if (node5.right != null) {
                node5.right.parent = node;
            }
            node5.right = node;
            node5.parent = node.parent;
            node.parent = node5;
            if (node2 != null) {
                if (node2.left == node) {
                    node2.left = node5;
                } else {
                    node2.right = node5;
                }
            } else {
                this.root = node5;
            }
            return node5;
        }
        if (n3 < -1) {
            Node node6;
            int n5 = this.getHeight(node4.left);
            if (n5 > 1) {
                node6 = node4.left;
                node4.left = node6.right;
                if (node6.right != null) {
                    node6.right.parent = node4;
                }
                node6.right = node4;
                node4.parent = node6;
                node.right = node6;
                node6.parent = node;
            }
            node6 = node.right;
            node.right = node6.left;
            if (node6.left != null) {
                node6.left.parent = node;
            }
            node6.left = node;
            node6.parent = node.parent;
            node.parent = node6;
            if (node2 != null) {
                if (node2.left == node) {
                    node2.left = node6;
                } else {
                    node2.right = node6;
                }
            } else {
                this.root = node6;
            }
            return node6;
        }
        return node;
    }

    public class TreeIterator
    implements Iterator<E> {
        protected Deque<Node> stack;
        protected final Direction direction;

        public TreeIterator(Node node) {
            this(node, Direction.ASCENDING);
        }

        public TreeIterator(Node node, Direction direction) {
            if (node == null) {
                throw new NullPointerException(Messages.getString("binarySearchTree.nullSubTreeForIterator"));
            }
            if (direction == null) {
                throw new NullPointerException(Messages.getString("binarySearchTree.nullTraversalDirection"));
            }
            this.direction = direction;
            this.stack = new ArrayDeque<Node>();
            if (direction == Direction.ASCENDING) {
                this.pushLeft(node);
            } else {
                this.pushRight(node);
            }
        }

        protected void pushLeft(Node node) {
            while (node != null) {
                this.stack.push(node);
                node = node.left;
            }
        }

        protected void pushRight(Node node) {
            while (node != null) {
                this.stack.push(node);
                node = node.right;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public E next() {
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            Node node = this.stack.pop();
            if (this.direction == Direction.ASCENDING) {
                this.pushLeft(node.right);
            } else {
                this.pushRight(node.left);
            }
            return node.comparable;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }

    protected static class Node {
        public E comparable;
        public Node parent;
        public Node left;
        public Node right;
        final /* synthetic */ BinarySearchTree this$0;

        public Node(E e) {
            this(var1_1, (Comparable)e, null, null, null);
        }

        public Node(E e, Node node, Node node2, Node node3) {
            this.this$0 = var1_1;
            if (e == null) {
                throw new NullPointerException(Messages.getString("binarySearchTree.nullComparable"));
            }
            this.comparable = e;
            this.parent = node;
            this.left = node2;
            this.right = node3;
        }

        public String toString() {
            return this.comparable.toString();
        }

        public boolean isLeftChild() {
            if (this.parent == null) {
                return false;
            }
            return this.parent.left == this;
        }
    }
}

