/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j;

import br.com.etyllica.core.graphics.Graphic;
import br.com.etyllica.layer.Layer;
import java.awt.geom.AffineTransform;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.geometry.Rectangle;

public class RigidBody
extends Body {
    private Layer layer;

    public RigidBody(Layer layer) {
        this.layer = layer;
        this.addFixture(new BodyFixture(new Rectangle((double)layer.getW() * layer.getScaleX(), (double)layer.getH() * layer.getScaleY())));
        this.translate((double)layer.getX() + (double)layer.getW() * layer.getScaleX() / 2.0, (double)layer.getY() + (double)layer.getH() * layer.getScaleY() / 2.0);
        this.setMass();
    }

    public void draw(Graphic graphic) {
        AffineTransform affineTransform = new AffineTransform();
        float f = this.layer.getX() + this.layer.getW() / 2;
        float f2 = this.layer.getY() + this.layer.getH() / 2;
        affineTransform.translate(this.transform.getTranslationX() - (double)f, this.transform.getTranslationY() - (double)f2);
        affineTransform.concatenate(AffineTransform.getRotateInstance(this.transform.getRotation(), this.layer.getX() + this.layer.getW() / 2, this.layer.getY() + this.layer.getH() / 2));
        graphic.setTransform(affineTransform);
        this.layer.simpleDraw(graphic);
        graphic.resetTransform();
    }

    public Layer getLayer() {
        return this.layer;
    }
}

