/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import org.dyn4j.collision.AbstractBounds;
import org.dyn4j.collision.Bounds;
import org.dyn4j.collision.Collidable;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;

public class AxisAlignedBounds
extends AbstractBounds
implements Bounds,
Transformable {
    protected AABB aabb;

    public AxisAlignedBounds(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        double d3 = d * 0.5;
        double d4 = d2 * 0.5;
        this.aabb = new AABB(-d3, -d4, d3, d4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AxisAlignedBounds[Width=").append(this.aabb.getWidth()).append("|Height=").append(this.aabb.getHeight()).append("|Translation=").append(this.getTranslation()).append("]");
        return stringBuilder.toString();
    }

    @Override
    public boolean isOutside(Collidable collidable) {
        AABB aABB;
        Vector2 vector2 = this.transform.getTranslation();
        AABB aABB2 = this.aabb.getTranslated(vector2);
        return !aABB2.overlaps(aABB = collidable.createAABB());
    }

    public AABB getBounds() {
        return this.aabb.getTranslated(this.transform.getTranslation());
    }

    public Vector2 getTranslation() {
        return this.transform.getTranslation();
    }

    public double getWidth() {
        return this.aabb.getWidth();
    }

    public double getHeight() {
        return this.aabb.getHeight();
    }

    @Override
    public void rotate(double d) {
    }

    @Override
    public void rotate(double d, double d2, double d3) {
    }

    @Override
    public void rotate(double d, Vector2 vector2) {
    }
}

