/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.collision.broadphase.AbstractAABBDetector;
import org.dyn4j.collision.broadphase.BroadphaseDetector;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Vector2;

public class DynamicAABBTree<E extends Collidable>
extends AbstractAABBDetector<E>
implements BroadphaseDetector<E> {
    protected Node root;
    protected List<Node> proxyList;
    protected Map<UUID, Node> proxyMap;

    public DynamicAABBTree() {
        this(64);
    }

    public DynamicAABBTree(int n) {
        this.proxyList = new ArrayList<Node>(n);
        this.proxyMap = new HashMap<UUID, Node>(n * 4 / 3 + 1, 0.75f);
    }

    @Override
    public void add(E e) {
        AABB aABB = e.createAABB();
        aABB.expand(this.expansion);
        Node node = new Node();
        node.collidable = e;
        node.aabb = aABB;
        this.proxyList.add(node);
        this.proxyMap.put(e.getId(), node);
        this.insert(node);
    }

    @Override
    public void remove(E e) {
        Node node = this.proxyMap.get(e.getId());
        if (node != null) {
            this.remove(node);
            this.proxyList.remove(node);
            this.proxyMap.remove(e.getId());
        }
    }

    @Override
    public void update(E e) {
        Node node = this.proxyMap.get(e.getId());
        if (node != null) {
            AABB aABB = e.createAABB();
            if (node.aabb.contains(aABB)) {
                return;
            }
            aABB.expand(this.expansion);
            this.remove(node);
            node.aabb = aABB;
            this.insert(node);
        }
    }

    @Override
    public void clear() {
        this.proxyList.clear();
        this.proxyMap.clear();
        this.root = null;
    }

    @Override
    public AABB getAABB(E e) {
        Node node = this.proxyMap.get(e.getId());
        if (node != null) {
            return node.aabb;
        }
        return null;
    }

    @Override
    public List<BroadphasePair<E>> detect() {
        Object object;
        int n;
        int n2 = this.proxyList.size();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        for (n = 0; n < n2; ++n) {
            object = this.proxyList.get(n);
            ((Node)object).tested = false;
        }
        n = Collisions.getEstimatedCollisionPairs(n2);
        object = new ArrayList(n);
        for (int i = 0; i < n2; ++i) {
            Node node = this.proxyList.get(i);
            this.detectNonRecursive(node, this.root, (List<BroadphasePair<E>>)object);
            node.tested = true;
        }
        return object;
    }

    @Override
    public List<E> detect(AABB aABB) {
        return this.detectNonRecursive(aABB, this.root);
    }

    @Override
    public List<E> raycast(Ray ray, double d) {
        if (this.proxyList.size() == 0) {
            return Collections.emptyList();
        }
        Vector2 vector2 = ray.getStart();
        Vector2 vector22 = ray.getDirectionVector();
        double d2 = d;
        if (d <= 0.0) {
            d2 = Double.MAX_VALUE;
        }
        double d3 = vector2.x;
        double d4 = vector2.x + vector22.x * d2;
        double d5 = vector2.y;
        double d6 = vector2.y + vector22.y * d2;
        Vector2 vector23 = new Vector2(Math.min(d3, d4), Math.min(d5, d6));
        Vector2 vector24 = new Vector2(Math.max(d3, d4), Math.max(d5, d6));
        AABB aABB = new AABB(vector23, vector24);
        return this.detect(aABB);
    }

    @Override
    public void shiftCoordinates(Vector2 vector2) {
        Node node = this.root;
        while (node != null) {
            if (node.left != null) {
                node = node.left;
                continue;
            }
            if (node.right != null) {
                node.aabb.translate(vector2);
                node = node.right;
                continue;
            }
            node.aabb.translate(vector2);
            boolean bl = false;
            while (node.parent != null) {
                if (node == node.parent.left && node.parent.right != null) {
                    node.parent.aabb.translate(vector2);
                    node = node.parent.right;
                    bl = true;
                    break;
                }
                node = node.parent;
            }
            if (bl) continue;
            break;
        }
    }

    protected void detect(Node node, Node node2, List<BroadphasePair<E>> list) {
        if (node2 == null) {
            return;
        }
        if (node2.tested) {
            return;
        }
        if (node.collidable == node2.collidable) {
            return;
        }
        if (node.aabb.overlaps(node2.aabb)) {
            if (node2.left == null) {
                BroadphasePair broadphasePair = new BroadphasePair(node.collidable, node2.collidable);
                list.add(broadphasePair);
                return;
            }
            if (node2.left != null) {
                this.detect(node, node2.left, list);
            }
            if (node2.right != null) {
                this.detect(node, node2.right, list);
            }
        }
    }

    protected void detectNonRecursive(Node node, Node node2, List<BroadphasePair<E>> list) {
        Node node3 = node2;
        while (node3 != null) {
            if (node3.aabb.overlaps(node.aabb)) {
                if (node3.left != null) {
                    node3 = node3.left;
                    continue;
                }
                if (!node3.tested && node3.collidable != node.collidable) {
                    BroadphasePair broadphasePair = new BroadphasePair(node.collidable, node3.collidable);
                    list.add(broadphasePair);
                }
            }
            boolean bl = false;
            while (node3.parent != null) {
                if (node3 == node3.parent.left && node3.parent.right != null) {
                    node3 = node3.parent.right;
                    bl = true;
                    break;
                }
                node3 = node3.parent;
            }
            if (bl) continue;
            break;
        }
    }

    protected void detect(AABB aABB, Node node, List<E> list) {
        if (aABB.overlaps(node.aabb)) {
            if (node.left == null) {
                list.add(node.collidable);
                return;
            }
            if (node.left != null) {
                this.detect(aABB, node.left, list);
            }
            if (node.right != null) {
                this.detect(aABB, node.right, list);
            }
        }
    }

    protected List<E> detectNonRecursive(AABB aABB, Node node) {
        int n = Collisions.getEstimatedCollisions();
        ArrayList arrayList = new ArrayList(n);
        while (node != null) {
            if (aABB.overlaps(node.aabb)) {
                if (node.left != null) {
                    node = node.left;
                    continue;
                }
                arrayList.add(node.collidable);
            }
            boolean bl = false;
            while (node.parent != null) {
                if (node == node.parent.left && node.parent.right != null) {
                    node = node.parent.right;
                    bl = true;
                    break;
                }
                node = node.parent;
            }
            if (bl) continue;
            break;
        }
        return arrayList;
    }

    protected void insert(Node node) {
        Object object;
        Object object2;
        if (this.root == null) {
            this.root = node;
            return;
        }
        AABB aABB = node.aabb;
        Node node2 = this.root;
        while (!node2.isLeaf()) {
            AABB aABB2;
            double d;
            AABB aABB3;
            object2 = node2.aabb;
            double d2 = ((AABB)object2).getPerimeter();
            object = ((AABB)object2).getUnion(aABB);
            double d3 = ((AABB)object).getPerimeter();
            double d4 = 2.0 * d3;
            double d5 = 2.0 * (d3 - d2);
            Node node3 = node2.left;
            Node node4 = node2.right;
            double d6 = 0.0;
            if (node3.isLeaf()) {
                aABB3 = node3.aabb.getUnion(aABB);
                d6 = aABB3.getPerimeter() + d5;
            } else {
                aABB3 = node3.aabb.getUnion(aABB);
                double d7 = node3.aabb.getPerimeter();
                d = aABB3.getPerimeter();
                d6 = d - d7 + d5;
            }
            double d8 = 0.0;
            if (node4.isLeaf()) {
                aABB2 = node4.aabb.getUnion(aABB);
                d8 = aABB2.getPerimeter() + d5;
            } else {
                aABB2 = node4.aabb.getUnion(aABB);
                d = node4.aabb.getPerimeter();
                double d9 = aABB2.getPerimeter();
                d8 = d9 - d + d5;
            }
            if (d4 < d6 && d4 < d8) break;
            if (d6 < d8) {
                node2 = node3;
                continue;
            }
            node2 = node4;
        }
        object2 = node2.parent;
        Node node5 = new Node();
        node5.parent = node2.parent;
        node5.aabb = node2.aabb.getUnion(aABB);
        node5.height = node2.height + 1;
        if (object2 != null) {
            if (((Node)object2).left == node2) {
                ((Node)object2).left = node5;
            } else {
                ((Node)object2).right = node5;
            }
            node5.left = node2;
            node5.right = node;
            node2.parent = node5;
            node.parent = node5;
        } else {
            node5.left = node2;
            node5.right = node;
            node2.parent = node5;
            node.parent = node5;
            this.root = node5;
        }
        node2 = node.parent;
        while (node2 != null) {
            node2 = this.balance(node2);
            Node node6 = node2.left;
            object = node2.right;
            node2.height = 1 + Math.max(node6.height, ((Node)object).height);
            node2.aabb = node6.aabb.getUnion(((Node)object).aabb);
            node2 = node2.parent;
        }
    }

    @Override
    protected void remove(Node node) {
        if (this.root == null) {
            return;
        }
        if (node == this.root) {
            this.root = null;
            return;
        }
        Node node2 = node.parent;
        Node node3 = node2.parent;
        Node node4 = node2.left == node ? node2.right : node2.left;
        if (node3 != null) {
            if (node3.left == node2) {
                node3.left = node4;
            } else {
                node3.right = node4;
            }
            node4.parent = node3;
            Node node5 = node3;
            while (node5 != null) {
                node5 = this.balance(node5);
                Node node6 = node5.left;
                Node node7 = node5.right;
                node5.height = 1 + Math.max(node6.height, node7.height);
                node5.aabb = node6.aabb.getUnion(node7.aabb);
                node5 = node5.parent;
            }
        } else {
            this.root = node4;
            node4.parent = null;
        }
    }

    protected Node balance(Node node) {
        Node node2 = node;
        if (node2.isLeaf() || node2.height < 2) {
            return node2;
        }
        Node node3 = node2.left;
        Node node4 = node2.right;
        int n = node4.height - node3.height;
        if (n > 1) {
            Node node5 = node4.left;
            Node node6 = node4.right;
            node4.left = node2;
            node4.parent = node2.parent;
            node2.parent = node4;
            if (node4.parent != null) {
                if (node4.parent.left == node2) {
                    node4.parent.left = node4;
                } else {
                    node4.parent.right = node4;
                }
            } else {
                this.root = node4;
            }
            if (node5.height > node6.height) {
                node4.right = node5;
                node2.right = node6;
                node6.parent = node2;
                node2.aabb = node3.aabb.getUnion(node6.aabb);
                node4.aabb = node2.aabb.getUnion(node5.aabb);
                node2.height = 1 + Math.max(node3.height, node6.height);
                node4.height = 1 + Math.max(node2.height, node5.height);
            } else {
                node4.right = node6;
                node2.right = node5;
                node5.parent = node2;
                node2.aabb = node3.aabb.getUnion(node5.aabb);
                node4.aabb = node2.aabb.getUnion(node6.aabb);
                node2.height = 1 + Math.max(node3.height, node5.height);
                node4.height = 1 + Math.max(node2.height, node6.height);
            }
            return node4;
        }
        if (n < -1) {
            Node node7 = node3.left;
            Node node8 = node3.right;
            node3.left = node2;
            node3.parent = node2.parent;
            node2.parent = node3;
            if (node3.parent != null) {
                if (node3.parent.left == node2) {
                    node3.parent.left = node3;
                } else {
                    node3.parent.right = node3;
                }
            } else {
                this.root = node3;
            }
            if (node7.height > node8.height) {
                node3.right = node7;
                node2.left = node8;
                node8.parent = node2;
                node2.aabb = node4.aabb.getUnion(node8.aabb);
                node3.aabb = node2.aabb.getUnion(node7.aabb);
                node2.height = 1 + Math.max(node4.height, node8.height);
                node3.height = 1 + Math.max(node2.height, node7.height);
            } else {
                node3.right = node8;
                node2.left = node7;
                node7.parent = node2;
                node2.aabb = node4.aabb.getUnion(node7.aabb);
                node3.aabb = node2.aabb.getUnion(node8.aabb);
                node2.height = 1 + Math.max(node4.height, node7.height);
                node3.height = 1 + Math.max(node2.height, node8.height);
            }
            return node3;
        }
        return node2;
    }

    protected void validate(Node node) {
        if (node == null) {
            return;
        }
        if (node == this.root) assert (node.parent == null);
        Node node2 = node.left;
        Node node3 = node.right;
        if (node.isLeaf()) {
            assert (node.left == null);
            assert (node.right == null);
            assert (node.height == 0);
            assert (node.collidable != null);
            return;
        }
        assert (node.aabb.contains(node2.aabb));
        if (node3 != null) assert (node.aabb.contains(node3.aabb));
        assert (node2.parent == node);
        assert (node3.parent == node);
        this.validate(node2);
        this.validate(node3);
    }

    protected class Node {
        public Node left;
        public Node right;
        public Node parent;
        public int height;
        public E collidable;
        public AABB aabb;
        public boolean tested = false;

        protected Node() {
        }

        public boolean isLeaf() {
            return this.left == null;
        }
    }
}

