/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.continuous;

import org.dyn4j.Epsilon;
import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.continuous.TimeOfImpactDetector;
import org.dyn4j.collision.narrowphase.DistanceDetector;
import org.dyn4j.collision.narrowphase.Gjk;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class ConservativeAdvancement
implements TimeOfImpactDetector {
    public static final double DEFAULT_DISTANCE_EPSILON = Math.cbrt(Epsilon.E);
    public static final int DEFAULT_MAX_ITERATIONS = 30;
    protected DistanceDetector distanceDetector = new Gjk();
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;
    protected int maxIterations = 30;

    public ConservativeAdvancement() {
    }

    public ConservativeAdvancement(DistanceDetector distanceDetector) {
        if (distanceDetector == null) {
            throw new NullPointerException(Messages.getString("collision.continuous.conservativeAdvancement.nullDistanceDetector"));
        }
        this.distanceDetector = distanceDetector;
    }

    @Override
    public boolean getTimeOfImpact(Convex convex, Transform transform, Vector2 vector2, double d, Convex convex2, Transform transform2, Vector2 vector22, double d2, TimeOfImpact timeOfImpact) {
        return this.getTimeOfImpact(convex, transform, vector2, d, convex2, transform2, vector22, d2, 0.0, 1.0, timeOfImpact);
    }

    @Override
    public boolean getTimeOfImpact(Convex convex, Transform transform, Vector2 vector2, double d, Convex convex2, Transform transform2, Vector2 vector22, double d2, double d3, double d4, TimeOfImpact timeOfImpact) {
        double d5;
        double d6;
        Transform transform3 = new Transform();
        Transform transform4 = new Transform();
        Separation separation = new Separation();
        boolean bl = this.distanceDetector.distance(convex, transform, convex2, transform2, separation);
        if (!bl) {
            return false;
        }
        double d7 = separation.getDistance();
        if (d7 < this.distanceEpsilon) {
            timeOfImpact.time = 0.0;
            timeOfImpact.separation = separation;
            return true;
        }
        Vector2 vector23 = separation.getNormal();
        double d8 = convex.getRadius();
        double d9 = convex2.getRadius();
        Vector2 vector24 = vector2.difference(vector22);
        double d10 = vector24.getMagnitude();
        if (d10 + (d6 = d8 * Math.abs(d) + d9 * Math.abs(d2)) == 0.0) {
            return false;
        }
        double d11 = d5 = d3;
        for (int i = 0; d7 > this.distanceEpsilon && i < this.maxIterations; ++i) {
            double d12 = vector24.dot(vector23);
            double d13 = d12 + d6;
            if (d13 <= Epsilon.E) {
                return false;
            }
            double d14 = d7 / d13;
            if ((d5 += d14) < d3) {
                return false;
            }
            if (d5 > d4) {
                return false;
            }
            if (d5 <= d11) break;
            d11 = d5;
            transform.lerp(vector2, d, d5, transform3);
            transform2.lerp(vector22, d2, d5, transform4);
            bl = this.distanceDetector.distance(convex, transform3, convex2, transform4, separation);
            d7 = separation.getDistance();
            if (!bl) {
                transform.lerp(vector2, d, d5 -= 0.5 * this.distanceEpsilon / d13, transform3);
                transform2.lerp(vector22, d2, d5, transform4);
                this.distanceDetector.distance(convex, transform3, convex2, transform4, separation);
                d7 = separation.getDistance();
                break;
            }
            vector23 = separation.getNormal();
            d7 = separation.getDistance();
        }
        timeOfImpact.time = d5;
        timeOfImpact.separation = separation;
        return true;
    }

    public DistanceDetector getDistanceDetector() {
        return this.distanceDetector;
    }

    public void setDistanceDetector(DistanceDetector distanceDetector) {
        if (distanceDetector == null) {
            throw new NullPointerException(Messages.getString("collision.continuous.conservativeAdvancement.nullDistanceDetector"));
        }
        this.distanceDetector = distanceDetector;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.continuous.conservativeAdvancement.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = d;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        if (n < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.continuous.conservativeAdvancement.invalidMaximumIterations"));
        }
        this.maxIterations = n;
    }
}

