/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.manifold;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.collision.manifold.IndexedManifoldPointId;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldPoint;
import org.dyn4j.collision.manifold.ManifoldPointId;
import org.dyn4j.collision.manifold.ManifoldSolver;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Edge;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vertex;

public class ClippingManifoldSolver
implements ManifoldSolver {
    @Override
    public boolean getManifold(Penetration penetration, Convex convex, Transform transform, Convex convex2, Transform transform2, Manifold manifold) {
        Object object;
        manifold.clear();
        Vector2 vector2 = penetration.getNormal();
        Feature feature = convex.getFarthestFeature(vector2, transform);
        if (feature.isVertex()) {
            Vertex vertex = (Vertex)feature;
            ManifoldPoint manifoldPoint = new ManifoldPoint(ManifoldPointId.DISTANCE, vertex.getPoint(), penetration.getDepth());
            manifold.points.add(manifoldPoint);
            manifold.normal = vector2.negate();
            return true;
        }
        Feature feature2 = convex2.getFarthestFeature(vector2.getNegative(), transform2);
        if (feature2.isVertex()) {
            Vertex vertex = (Vertex)feature2;
            ManifoldPoint manifoldPoint = new ManifoldPoint(ManifoldPointId.DISTANCE, vertex.getPoint(), penetration.getDepth());
            manifold.points.add(manifoldPoint);
            manifold.normal = vector2.negate();
            return true;
        }
        Edge edge = (Edge)feature;
        Object object2 = (Edge)feature2;
        boolean bl = false;
        Vector2 vector22 = edge.getEdge();
        Vector2 vector23 = ((Edge)object2).getEdge();
        if (Math.abs(vector22.dot(vector2)) > Math.abs(vector23.dot(vector2))) {
            object = edge;
            edge = object2;
            object2 = object;
            bl = true;
        }
        object = edge.getEdge();
        ((Vector2)object).normalize();
        double d = -((Vector2)object).dot(edge.getVertex1().getPoint());
        double d2 = ((Vector2)object).dot(edge.getVertex2().getPoint());
        List<Vertex> list = this.clip(((Edge)object2).getVertex1(), ((Edge)object2).getVertex2(), ((Vector2)object).getNegative(), d);
        if (list.size() < 2) {
            return false;
        }
        List<Vertex> list2 = this.clip(list.get(0), list.get(1), (Vector2)object, d2);
        if (list2.size() < 2) {
            return false;
        }
        Vector2 vector24 = ((Vector2)object).cross(1.0);
        double d3 = vector24.dot(edge.getMaximum().getPoint());
        manifold.normal = bl ? vector24.getNegative() : vector24;
        for (int i = 0; i < list2.size(); ++i) {
            Vertex vertex = list2.get(i);
            Vector2 vector25 = vertex.getPoint();
            double d4 = vector24.dot(vector25) - d3;
            if (!(d4 >= 0.0)) continue;
            IndexedManifoldPointId indexedManifoldPointId = new IndexedManifoldPointId(edge.getIndex(), ((Edge)object2).getIndex(), vertex.getIndex(), bl);
            ManifoldPoint manifoldPoint = new ManifoldPoint(indexedManifoldPointId, vector25, d4);
            manifold.points.add(manifoldPoint);
        }
        return manifold.points.size() != 0;
    }

    protected List<Vertex> clip(Vertex vertex, Vertex vertex2, Vector2 vector2, double d) {
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(2);
        Vector2 vector22 = vertex.getPoint();
        Vector2 vector23 = vertex2.getPoint();
        double d2 = vector2.dot(vector22) - d;
        double d3 = vector2.dot(vector23) - d;
        if (d2 <= 0.0) {
            arrayList.add(vertex);
        }
        if (d3 <= 0.0) {
            arrayList.add(vertex2);
        }
        if (d2 * d3 < 0.0) {
            Vector2 vector24 = vector22.to(vector23);
            double d4 = d2 / (d2 - d3);
            vector24.multiply(d4);
            vector24.add(vector22);
            if (d2 > 0.0) {
                arrayList.add(new Vertex(vector24, vertex.getIndex()));
            } else {
                arrayList.add(new Vertex(vector24, vertex2.getIndex()));
            }
        }
        return arrayList;
    }
}

