/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dyn4j.collision.narrowphase.FallbackCondition;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;

public class FallbackNarrowphaseDetector
implements NarrowphaseDetector {
    protected NarrowphaseDetector primaryNarrowphaseDetector;
    protected NarrowphaseDetector fallbackNarrowphaseDetector;
    protected List<FallbackCondition> fallbackConditions;

    public FallbackNarrowphaseDetector(NarrowphaseDetector narrowphaseDetector, NarrowphaseDetector narrowphaseDetector2) {
        this(narrowphaseDetector, narrowphaseDetector2, new ArrayList<FallbackCondition>());
    }

    public FallbackNarrowphaseDetector(NarrowphaseDetector narrowphaseDetector, NarrowphaseDetector narrowphaseDetector2, List<FallbackCondition> list) {
        if (narrowphaseDetector == null) {
            throw new NullPointerException();
        }
        if (narrowphaseDetector2 == null) {
            throw new NullPointerException();
        }
        this.primaryNarrowphaseDetector = narrowphaseDetector;
        this.fallbackNarrowphaseDetector = narrowphaseDetector2;
        this.fallbackConditions = list != null ? list : new ArrayList<FallbackCondition>();
    }

    public void addCondition(FallbackCondition fallbackCondition) {
        this.fallbackConditions.add(fallbackCondition);
        Collections.sort(this.fallbackConditions);
    }

    public boolean removeCondition(FallbackCondition fallbackCondition) {
        return this.fallbackConditions.remove(fallbackCondition);
    }

    public boolean containsCondition(FallbackCondition fallbackCondition) {
        return this.fallbackConditions.contains(fallbackCondition);
    }

    public int getConditionCount() {
        return this.fallbackConditions.size();
    }

    public FallbackCondition getCondition(int n) {
        return this.fallbackConditions.get(n);
    }

    public boolean isFallbackRequired(Convex convex, Convex convex2) {
        int n = this.fallbackConditions.size();
        for (int i = 0; i < n; ++i) {
            FallbackCondition fallbackCondition = this.fallbackConditions.get(i);
            if (fallbackCondition == null || !fallbackCondition.isMatch(convex, convex2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean detect(Convex convex, Transform transform, Convex convex2, Transform transform2) {
        if (this.isFallbackRequired(convex, convex2)) {
            return this.fallbackNarrowphaseDetector.detect(convex, transform, convex2, transform2);
        }
        return this.primaryNarrowphaseDetector.detect(convex, transform, convex2, transform2);
    }

    @Override
    public boolean detect(Convex convex, Transform transform, Convex convex2, Transform transform2, Penetration penetration) {
        if (this.isFallbackRequired(convex, convex2)) {
            return this.fallbackNarrowphaseDetector.detect(convex, transform, convex2, transform2, penetration);
        }
        return this.primaryNarrowphaseDetector.detect(convex, transform, convex2, transform2, penetration);
    }

    public NarrowphaseDetector getPrimaryNarrowphaseDetector() {
        return this.primaryNarrowphaseDetector;
    }

    public NarrowphaseDetector getFallbackNarrowphaseDetector() {
        return this.fallbackNarrowphaseDetector;
    }
}

