/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class MinkowskiSum {
    protected Convex convex1;
    protected Convex convex2;
    protected Transform transform1;
    protected Transform transform2;

    public MinkowskiSum(Convex convex, Transform transform, Convex convex2, Transform transform2) {
        this.convex1 = convex;
        this.convex2 = convex2;
        this.transform1 = transform;
        this.transform2 = transform2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MinkowskiSum[Shape1=").append(this.convex1).append("|Transform1=").append(this.transform1).append("|Shape2=").append(this.convex2).append("|Transform2=").append(this.transform2).append("]");
        return stringBuilder.toString();
    }

    public Vector2 support(Vector2 vector2) {
        Vector2 vector22 = this.convex1.getFarthestPoint(vector2, this.transform1);
        vector2.negate();
        Vector2 vector23 = this.convex2.getFarthestPoint(vector2, this.transform2);
        vector2.negate();
        return vector22.subtract(vector23);
    }

    public void support(Vector2 vector2, Point point) {
        Vector2 vector22 = this.convex1.getFarthestPoint(vector2, this.transform1);
        vector2.negate();
        Vector2 vector23 = this.convex2.getFarthestPoint(vector2, this.transform2);
        vector2.negate();
        point.set(vector22, vector23);
    }

    public Convex getConvex1() {
        return this.convex1;
    }

    public void setConvex1(Convex convex) {
        this.convex1 = convex;
    }

    public Convex getConvex2() {
        return this.convex2;
    }

    public void setConvex2(Convex convex) {
        this.convex2 = convex;
    }

    public Transform getTransform1() {
        return this.transform1;
    }

    public void setTransform1(Transform transform) {
        this.transform1 = transform;
    }

    public Transform getTransform2() {
        return this.transform2;
    }

    public void setTransform2(Transform transform) {
        this.transform2 = transform;
    }

    public static class Point {
        protected Vector2 p1;
        protected Vector2 p2;
        protected Vector2 p;

        protected Point() {
        }

        public Point(Vector2 vector2, Vector2 vector22) {
            this.set(vector2, vector22);
        }

        public void set(Vector2 vector2, Vector2 vector22) {
            this.p1 = vector2;
            this.p2 = vector22;
            this.p = vector2.difference(vector22);
        }

        public void set(Point point) {
            this.p1 = point.p1;
            this.p2 = point.p2;
            this.p = point.p;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("MinkowskiSum.Point[Point=").append(this.p).append("|SupportPoint1=").append(this.p1).append("|SupportPoint2=").append(this.p2).append("]");
            return stringBuilder.toString();
        }
    }
}

