/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Collisions;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.Force;
import org.dyn4j.dynamics.Torque;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.dynamics.contact.ContactEdge;
import org.dyn4j.dynamics.contact.ContactPoint;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.dynamics.joint.JointEdge;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Transformable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Body
implements Collidable,
Transformable {
    private static final int TYPICAL_FIXTURE_COUNT = 1;
    public static final double DEFAULT_LINEAR_DAMPING = 0.0;
    public static final double DEFAULT_ANGULAR_DAMPING = 0.01;
    protected static final int AUTO_SLEEP = 1;
    protected static final int ASLEEP = 2;
    protected static final int ACTIVE = 4;
    protected static final int ISLAND = 8;
    protected static final int BULLET = 16;
    protected World world = null;
    protected UUID id;
    protected Transform transform0;
    protected Transform transform;
    protected List<BodyFixture> fixtures;
    protected double radius;
    protected Object userData;
    protected Mass mass;
    protected Vector2 velocity;
    protected double angularVelocity;
    protected Vector2 force;
    protected double torque;
    protected List<Force> forces;
    protected List<Torque> torques;
    protected int state;
    protected double sleepTime;
    protected double linearDamping;
    protected double angularDamping;
    protected double gravityScale;
    protected List<ContactEdge> contacts;
    protected List<JointEdge> joints;

    public Body() {
        this(1);
    }

    public Body(int n) {
        this.fixtures = new ArrayList<BodyFixture>(n);
        this.radius = 0.0;
        this.mass = new Mass();
        this.id = UUID.randomUUID();
        this.transform0 = new Transform();
        this.transform = new Transform();
        this.velocity = new Vector2();
        this.angularVelocity = 0.0;
        this.force = new Vector2();
        this.torque = 0.0;
        this.forces = new ArrayList<Force>(8);
        this.torques = new ArrayList<Torque>(8);
        this.state = 0;
        this.state |= 1;
        this.state |= 4;
        this.sleepTime = 0.0;
        this.linearDamping = 0.0;
        this.angularDamping = 0.01;
        this.gravityScale = 1.0;
        this.contacts = new ArrayList<ContactEdge>(Collisions.getEstimatedCollisions());
        this.joints = new ArrayList<JointEdge>(2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Body[Id=").append(this.id).append("|Fixtures={");
        int n = this.fixtures.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.fixtures.get(i));
        }
        stringBuilder.append("}|InitialTransform=").append(this.transform0).append("|Transform=").append(this.transform).append("|RotationDiscRadius=").append(this.radius).append("|Mass=").append(this.mass).append("|Velocity=").append(this.velocity).append("|AngularVelocity=").append(this.angularVelocity).append("|Force=").append(this.force).append("|Torque=").append(this.torque).append("|AccumulatedForce=").append(this.getAccumulatedForce()).append("|AccumulatedTorque=").append(this.getAccumulatedTorque()).append("|IsAutoSleepingEnabled=").append(this.isAutoSleepingEnabled()).append("|IsAsleep=").append(this.isAsleep()).append("|IsActive=").append(this.isActive()).append("|IsOnIsland=").append(this.isOnIsland()).append("|IsBullet=").append(this.isBullet()).append("|SleepTime=").append(this.sleepTime).append("|LinearDamping=").append(this.linearDamping).append("|AngularDamping").append(this.angularDamping).append("|GravityScale=").append(this.gravityScale).append("]");
        return stringBuilder.toString();
    }

    public BodyFixture addFixture(Convex convex) {
        if (convex == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullShape"));
        }
        BodyFixture bodyFixture = new BodyFixture(convex);
        this.fixtures.add(bodyFixture);
        return bodyFixture;
    }

    public BodyFixture addFixture(Convex convex, double d) {
        if (convex == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullShape"));
        }
        BodyFixture bodyFixture = new BodyFixture(convex);
        bodyFixture.setDensity(d);
        this.fixtures.add(bodyFixture);
        return bodyFixture;
    }

    public BodyFixture addFixture(Convex convex, double d, double d2, double d3) {
        if (convex == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullShape"));
        }
        BodyFixture bodyFixture = new BodyFixture(convex);
        bodyFixture.setDensity(d);
        bodyFixture.setFriction(d2);
        bodyFixture.setRestitution(d3);
        this.fixtures.add(bodyFixture);
        return bodyFixture;
    }

    public Body addFixture(BodyFixture bodyFixture) {
        if (bodyFixture == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.addNullFixture"));
        }
        this.fixtures.add(bodyFixture);
        return this;
    }

    public boolean removeFixture(BodyFixture bodyFixture) {
        if (bodyFixture == null) {
            return false;
        }
        int n = this.fixtures.size();
        if (n > 0) {
            return this.fixtures.remove(bodyFixture);
        }
        return false;
    }

    public BodyFixture removeFixture(int n) {
        return this.fixtures.remove(n);
    }

    public List<BodyFixture> removeAllFixtures() {
        List<BodyFixture> list = this.fixtures;
        this.fixtures = new ArrayList<BodyFixture>(1);
        return list;
    }

    public boolean containsFixture(BodyFixture bodyFixture) {
        return this.fixtures.contains(bodyFixture);
    }

    public Body setMass() {
        return this.setMass(Mass.Type.NORMAL);
    }

    public Body setMass(Mass.Type type) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullMassType"));
        }
        int n = this.fixtures.size();
        if (n == 0) {
            this.mass = new Mass();
        } else if (n == 1) {
            this.mass = this.fixtures.get(0).createMass();
        } else {
            ArrayList<Mass> arrayList = new ArrayList<Mass>(n);
            for (int i = 0; i < n; ++i) {
                Mass mass = this.fixtures.get(i).createMass();
                arrayList.add(mass);
            }
            this.mass = Mass.create(arrayList);
        }
        this.mass.setType(type);
        this.setRotationDiscRadius();
        return this;
    }

    public Body setMass(Mass mass) {
        if (mass == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullMass"));
        }
        this.mass = mass;
        this.setRotationDiscRadius();
        return this;
    }

    public Body setMassType(Mass.Type type) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullMassType"));
        }
        if (this.mass == null) {
            this.setMass(type);
        } else {
            this.mass.setType(type);
        }
        return this;
    }

    protected void setRotationDiscRadius() {
        double d = 0.0;
        int n = this.fixtures.size();
        if (n == 0) {
            this.radius = 0.0;
            return;
        }
        Vector2 vector2 = this.mass.getCenter();
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = this.fixtures.get(i);
            Convex convex = bodyFixture.getShape();
            double d2 = convex.getRadius(vector2);
            d = Math.max(d, d2);
        }
        this.radius = d;
    }

    public Mass getMass() {
        return this.mass;
    }

    public Body applyForce(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForce"));
        }
        if (this.mass.getMass() == 0.0) {
            return this;
        }
        this.forces.add(new Force(vector2));
        this.setAsleep(false);
        return this;
    }

    public Body applyForce(Force force) {
        if (force == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForce"));
        }
        if (this.mass.getMass() == 0.0) {
            return this;
        }
        this.forces.add(force);
        this.setAsleep(false);
        return this;
    }

    public Body applyTorque(double d) {
        this.torques.add(new Torque(d));
        if (this.mass.getInertia() == 0.0) {
            return this;
        }
        this.setAsleep(false);
        return this;
    }

    public Body applyTorque(Torque torque) {
        if (torque == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullTorque"));
        }
        if (this.mass.getInertia() == 0.0) {
            return this;
        }
        this.torques.add(torque);
        this.setAsleep(false);
        return this;
    }

    public Body applyForce(Vector2 vector2, Vector2 vector22) {
        Vector2 vector23;
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullForceForTorque"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullPointForTorque"));
        }
        boolean bl = false;
        if (this.mass.getMass() != 0.0) {
            this.forces.add(new Force(vector2));
            bl = true;
        }
        if (this.mass.getInertia() != 0.0 && !(vector23 = this.getWorldCenter().to(vector22)).isZero()) {
            double d = vector23.cross(vector2);
            this.torques.add(new Torque(d));
            bl = true;
        }
        if (bl) {
            this.setAsleep(false);
        }
        return this;
    }

    public Body applyImpulse(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullImpulse"));
        }
        double d = this.mass.getInverseMass();
        if (d == 0.0) {
            return this;
        }
        this.velocity.add(vector2.x * d, vector2.y * d);
        this.setAsleep(false);
        return this;
    }

    public Body applyImpulse(double d) {
        double d2 = this.mass.getInverseInertia();
        if (d2 == 0.0) {
            return this;
        }
        this.angularVelocity += d2 * d;
        this.setAsleep(false);
        return this;
    }

    public Body applyImpulse(Vector2 vector2, Vector2 vector22) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullImpulse"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullPointForImpulse"));
        }
        boolean bl = false;
        double d = this.mass.getInverseMass();
        double d2 = this.mass.getInverseInertia();
        if (d != 0.0) {
            this.velocity.add(vector2.x * d, vector2.y * d);
            bl = true;
        }
        if (d2 != 0.0) {
            Vector2 vector23 = this.getWorldCenter().to(vector22);
            this.angularVelocity += d2 * vector23.cross(vector2);
            bl = true;
        }
        if (bl) {
            this.setAsleep(false);
        }
        return this;
    }

    public void clearForce() {
        this.force.zero();
    }

    public void clearAccumulatedForce() {
        this.forces.clear();
    }

    public void clearTorque() {
        this.torque = 0.0;
    }

    public void clearAccumulatedTorque() {
        this.torques.clear();
    }

    protected void accumulate(double d) {
        Object object;
        Iterator<Object> iterator;
        this.force.zero();
        int n = this.forces.size();
        if (n > 0) {
            iterator = this.forces.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ((Force)object).apply(this);
                if (!((Force)object).isComplete(d)) continue;
                iterator.remove();
            }
        }
        this.torque = 0.0;
        n = this.torques.size();
        if (n > 0) {
            iterator = this.torques.iterator();
            while (iterator.hasNext()) {
                object = (Torque)iterator.next();
                ((Torque)object).apply(this);
                if (!((Torque)object).isComplete(d)) continue;
                iterator.remove();
            }
        }
    }

    public boolean isStatic() {
        return this.mass.isInfinite() && this.velocity.isZero() && Math.abs(this.angularVelocity) <= Epsilon.E;
    }

    public boolean isKinematic() {
        return this.mass.isInfinite() && (!this.velocity.isZero() || Math.abs(this.angularVelocity) > Epsilon.E);
    }

    public boolean isDynamic() {
        return this.mass.getType() != Mass.Type.INFINITE;
    }

    protected void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void setAutoSleepingEnabled(boolean bl) {
        this.state = bl ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
    }

    public boolean isAutoSleepingEnabled() {
        return (this.state & 1) == 1;
    }

    public boolean isAsleep() {
        return (this.state & 2) == 2;
    }

    public void setAsleep(boolean bl) {
        if (bl) {
            this.state |= 2;
            this.velocity.zero();
            this.angularVelocity = 0.0;
            this.forces.clear();
            this.torques.clear();
        } else if ((this.state & 2) == 2) {
            this.sleepTime = 0.0;
            this.state &= 0xFFFFFFFD;
        }
    }

    protected double getSleepTime() {
        return this.sleepTime;
    }

    public boolean isActive() {
        return (this.state & 4) == 4;
    }

    public void setActive(boolean bl) {
        this.state = bl ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
    }

    protected boolean isOnIsland() {
        return (this.state & 8) == 8;
    }

    protected void setOnIsland(boolean bl) {
        this.state = bl ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    public boolean isBullet() {
        return (this.state & 0x10) == 16;
    }

    public void setBullet(boolean bl) {
        this.state = bl ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
    }

    public boolean isConnected(Body body) {
        if (body == null) {
            return false;
        }
        int n = this.joints.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            JointEdge jointEdge = this.joints.get(i);
            if (jointEdge.getOther() != body) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(Body body, boolean bl) {
        if (body == null) {
            return false;
        }
        int n = this.joints.size();
        if (n == 0) {
            return false;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            JointEdge jointEdge = this.joints.get(i);
            if (jointEdge.getOther() != body) continue;
            Joint joint = jointEdge.getJoint();
            bl3 = true;
            bl2 |= joint.isCollisionAllowed();
        }
        if (!bl3) {
            return false;
        }
        return bl2 == bl;
    }

    public boolean isInContact(Body body) {
        if (body == null) {
            return false;
        }
        int n = this.contacts.size();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            ContactEdge contactEdge = this.contacts.get(i);
            if (contactEdge.getOther() != body) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
    }

    @Override
    public void rotate(double d, Vector2 vector2) {
        this.transform.rotate(d, vector2);
    }

    @Override
    public void rotate(double d) {
        this.transform.rotate(d);
    }

    public void rotateAboutCenter(double d) {
        Vector2 vector2 = this.getWorldCenter();
        this.rotate(d, vector2);
    }

    @Override
    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
    }

    @Override
    public void translate(Vector2 vector2) {
        this.transform.translate(vector2);
    }

    public void translateToOrigin() {
        Vector2 vector2 = this.transform.getTransformed(this.mass.getCenter());
        this.transform.translate(-vector2.x, -vector2.y);
    }

    protected void shiftCoordinates(Vector2 vector2) {
        this.transform.translate(vector2);
    }

    @Override
    public BodyFixture getFixture(int n) {
        return this.fixtures.get(n);
    }

    public BodyFixture getFixture(Vector2 vector2) {
        int n = this.fixtures.size();
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = this.fixtures.get(i);
            Convex convex = bodyFixture.getShape();
            if (!convex.contains(vector2, this.transform)) continue;
            return bodyFixture;
        }
        return null;
    }

    public List<BodyFixture> getFixtures(Vector2 vector2) {
        ArrayList<BodyFixture> arrayList = new ArrayList<BodyFixture>();
        int n = this.fixtures.size();
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = this.fixtures.get(i);
            Convex convex = bodyFixture.getShape();
            if (!convex.contains(vector2, this.transform)) continue;
            arrayList.add(bodyFixture);
        }
        return arrayList;
    }

    public BodyFixture removeFixture(Vector2 vector2) {
        int n = this.fixtures.size();
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = this.fixtures.get(i);
            Convex convex = bodyFixture.getShape();
            if (!convex.contains(vector2, this.transform)) continue;
            this.fixtures.remove(i);
            return bodyFixture;
        }
        return null;
    }

    public List<BodyFixture> removeFixtures(Vector2 vector2) {
        ArrayList<BodyFixture> arrayList = new ArrayList<BodyFixture>();
        Iterator<BodyFixture> iterator = this.fixtures.iterator();
        while (iterator.hasNext()) {
            BodyFixture bodyFixture = iterator.next();
            Convex convex = bodyFixture.getShape();
            if (!convex.contains(vector2, this.transform)) continue;
            iterator.remove();
            arrayList.add(bodyFixture);
        }
        return arrayList;
    }

    @Override
    public int getFixtureCount() {
        return this.fixtures.size();
    }

    public List<BodyFixture> getFixtures() {
        ArrayList<BodyFixture> arrayList = new ArrayList<BodyFixture>(this.fixtures.size());
        arrayList.addAll(this.fixtures);
        return arrayList;
    }

    @Override
    public Transform getTransform() {
        return this.transform;
    }

    public Transform getInitialTransform() {
        return this.transform0;
    }

    public double getRotationDiscRadius() {
        return this.radius;
    }

    public void setTransform(Transform transform) {
        if (transform == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullTransform"));
        }
        this.transform.set(transform);
        this.transform0.set(transform);
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public AABB createAABB() {
        return this.createAABB(this.transform);
    }

    public AABB createAABB(Transform transform) {
        int n = this.fixtures.size();
        if (n > 0) {
            AABB aABB = this.fixtures.get(0).getShape().createAABB(transform);
            for (int i = 1; i < n; ++i) {
                AABB aABB2 = this.fixtures.get(i).getShape().createAABB(transform);
                aABB.union(aABB2);
            }
            return aABB;
        }
        return new AABB(new Vector2(0.0, 0.0), new Vector2(0.0, 0.0));
    }

    public AABB createSweptAABB() {
        return this.createSweptAABB(this.transform0, this.transform);
    }

    public AABB createSweptAABB(Transform transform, Transform transform2) {
        Vector2 vector2 = transform.getTransformed(this.mass.getCenter());
        Vector2 vector22 = transform2.getTransformed(this.mass.getCenter());
        return new AABB(new Vector2(Math.min(vector2.x, vector22.x) - this.radius, Math.min(vector2.y, vector22.y) - this.radius), new Vector2(Math.max(vector2.x, vector22.x) + this.radius, Math.max(vector2.y, vector22.y) + this.radius));
    }

    public Vector2 getChangeInPosition() {
        return this.transform.getTranslation().subtract(this.transform0.getTranslation());
    }

    public double getChangeInOrientation() {
        double d = this.transform0.getRotation();
        double d2 = this.transform.getRotation();
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        if (d2 < 0.0) {
            d2 += Math.PI * 2;
        }
        double d3 = d2 - d;
        if (d2 < d && this.angularVelocity > 0.0) {
            d3 += Math.PI * 2;
        }
        if (d2 > d && this.angularVelocity < 0.0) {
            d3 -= Math.PI * 2;
        }
        return d3;
    }

    public Vector2 getLocalCenter() {
        return this.mass.getCenter();
    }

    public Vector2 getWorldCenter() {
        return this.transform.getTransformed(this.mass.getCenter());
    }

    public Vector2 getLocalPoint(Vector2 vector2) {
        return this.transform.getInverseTransformed(vector2);
    }

    public Vector2 getWorldPoint(Vector2 vector2) {
        return this.transform.getTransformed(vector2);
    }

    public Vector2 getLocalVector(Vector2 vector2) {
        return this.transform.getInverseTransformedR(vector2);
    }

    public Vector2 getWorldVector(Vector2 vector2) {
        return this.transform.getTransformedR(vector2);
    }

    public boolean contains(Vector2 vector2) {
        int n = this.fixtures.size();
        for (int i = 0; i < n; ++i) {
            BodyFixture bodyFixture = this.fixtures.get(i);
            Convex convex = bodyFixture.getShape();
            if (!convex.contains(vector2, this.transform)) continue;
            return true;
        }
        return false;
    }

    public Vector2 getLinearVelocity() {
        return this.velocity;
    }

    public Vector2 getLinearVelocity(Vector2 vector2) {
        Vector2 vector22 = this.getWorldCenter();
        Vector2 vector23 = vector22.to(vector2);
        return vector23.cross(this.angularVelocity).add(this.velocity);
    }

    public void setLinearVelocity(Vector2 vector2) {
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.body.nullVelocity"));
        }
        this.velocity.set(vector2);
    }

    public void setLinearVelocity(double d, double d2) {
        this.velocity.x = d;
        this.velocity.y = d2;
    }

    public double getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(double d) {
        this.angularVelocity = d;
    }

    public Vector2 getForce() {
        return this.force;
    }

    public Vector2 getAccumulatedForce() {
        int n = this.forces.size();
        Vector2 vector2 = new Vector2();
        for (int i = 0; i < n; ++i) {
            Vector2 vector22 = this.forces.get((int)i).force;
            vector2.add(vector22);
        }
        return vector2;
    }

    public double getTorque() {
        return this.torque;
    }

    public double getAccumulatedTorque() {
        int n = this.torques.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.torques.get((int)i).torque;
        }
        return d;
    }

    public double getLinearDamping() {
        return this.linearDamping;
    }

    public void setLinearDamping(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.invalidLinearDamping"));
        }
        this.linearDamping = d;
    }

    public double getAngularDamping() {
        return this.angularDamping;
    }

    public void setAngularDamping(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.invalidAngularDamping"));
        }
        this.angularDamping = d;
    }

    public double getGravityScale() {
        return this.gravityScale;
    }

    public void setGravityScale(double d) {
        this.gravityScale = d;
    }

    public List<Body> getJoinedBodies() {
        int n = this.joints.size();
        ArrayList<Body> arrayList = new ArrayList<Body>(n);
        for (int i = 0; i < n; ++i) {
            JointEdge jointEdge = this.joints.get(i);
            Body body = jointEdge.getOther();
            if (arrayList.contains(body)) continue;
            arrayList.add(body);
        }
        return arrayList;
    }

    public List<Joint> getJoints() {
        int n = this.joints.size();
        ArrayList<Joint> arrayList = new ArrayList<Joint>(n);
        for (int i = 0; i < n; ++i) {
            JointEdge jointEdge = this.joints.get(i);
            arrayList.add(jointEdge.getJoint());
        }
        return arrayList;
    }

    public List<Body> getInContactBodies(boolean bl) {
        int n = this.contacts.size();
        ArrayList<Body> arrayList = new ArrayList<Body>(n);
        for (int i = 0; i < n; ++i) {
            Body body;
            ContactEdge contactEdge = this.contacts.get(i);
            ContactConstraint contactConstraint = contactEdge.getContactConstraint();
            if (bl != contactConstraint.isSensor() || arrayList.contains(body = contactEdge.getOther())) continue;
            arrayList.add(body);
        }
        return arrayList;
    }

    public List<ContactPoint> getContacts(boolean bl) {
        int n = this.contacts.size();
        ArrayList<ContactPoint> arrayList = new ArrayList<ContactPoint>(n * 2);
        for (int i = 0; i < n; ++i) {
            ContactEdge contactEdge = this.contacts.get(i);
            ContactConstraint contactConstraint = contactEdge.getContactConstraint();
            if (bl != contactConstraint.isSensor()) continue;
            List<Contact> list = contactConstraint.getContacts();
            int n2 = list.size();
            for (int j = 0; j < n2; ++j) {
                Contact contact = list.get(j);
                ContactPoint contactPoint = new ContactPoint(new ContactPointId(contactConstraint.getId(), contact.getId()), contactConstraint.body1, contactConstraint.getFixture1(), contactConstraint.body2, contactConstraint.getFixture2(), contact.isEnabled(), contact.getPoint(), contactConstraint.getNormal(), contact.getDepth());
                arrayList.add(contactPoint);
            }
        }
        return arrayList;
    }

    @Deprecated
    public Body apply(Vector2 vector2, Vector2 vector22) {
        return this.applyForce(vector2, vector22);
    }

    @Deprecated
    public Body apply(Torque torque) {
        return this.applyTorque(torque);
    }

    @Deprecated
    public Body apply(double d) {
        return this.applyTorque(d);
    }

    @Deprecated
    public Body apply(Force force) {
        return this.applyForce(force);
    }

    @Deprecated
    public Body apply(Vector2 vector2) {
        return this.applyForce(vector2);
    }

    @Deprecated
    public Vector2 getVelocity() {
        return this.getLinearVelocity();
    }

    @Deprecated
    public Vector2 getVelocity(Vector2 vector2) {
        return this.getLinearVelocity(vector2);
    }

    @Deprecated
    public void setVelocity(Vector2 vector2) {
        this.setLinearVelocity(vector2);
    }
}

