/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.collision.Fixture;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Mass;
import org.dyn4j.resources.Messages;

public class BodyFixture
extends Fixture {
    public static final double DEFAULT_FRICTION = 0.2;
    public static final double DEFAULT_RESTITUTION = 0.0;
    public static final double DEFAULT_DENSITY = 1.0;
    protected double density = 1.0;
    protected double friction = 0.2;
    protected double restitution = 0.0;

    public BodyFixture(Convex convex) {
        super(convex);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BodyFixture[Id=").append(this.id).append("|Shape=").append(this.shape).append("|Filter=").append(this.filter).append("|IsSensor=").append(this.sensor).append("|Density=").append(this.density).append("|Friction=").append(this.friction).append("|Restitution=").append(this.restitution).append("|UserData=").append(this.userData).append("]");
        return stringBuilder.toString();
    }

    public void setDensity(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.fixture.invalidDensity"));
        }
        this.density = d;
    }

    public double getDensity() {
        return this.density;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.fixture.invalidFriction"));
        }
        this.friction = d;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setRestitution(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.body.fixture.invalidRestitution"));
        }
        this.restitution = d;
    }

    public Mass createMass() {
        return this.shape.createMass(this.density);
    }
}

