/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics;

import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.World;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public abstract class Constraint {
    protected World world;
    protected Body body1;
    protected Body body2;
    protected boolean onIsland;
    protected Object userData;

    public Constraint(Body body, Body body2) {
        if (body == null) {
            throw new NullPointerException(Messages.getString("dynamics.constraint.nullBody1"));
        }
        if (body2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.constraint.nullBody2"));
        }
        this.body1 = body;
        this.body2 = body2;
        this.onIsland = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Body1=").append(this.body1).append("|Body2=").append(this.body2).append("|IsOnIsland=").append(this.onIsland);
        return stringBuilder.toString();
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public void setBody1(Body body) {
        if (body == null) {
            throw new NullPointerException(Messages.getString("dynamics.constraint.nullBody1"));
        }
        this.body1 = body;
    }

    public void setBody2(Body body) {
        if (body == null) {
            throw new NullPointerException(Messages.getString("dynamics.constraint.nullBody2"));
        }
        this.body2 = body;
    }

    protected void setWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    protected abstract void shiftCoordinates(Vector2 var1);

    protected void setOnIsland(boolean bl) {
        this.onIsland = bl;
    }

    protected boolean isOnIsland() {
        return this.onIsland;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }
}

