/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import java.util.Iterator;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.World;
import org.dyn4j.dynamics.contact.Contact;
import org.dyn4j.dynamics.contact.ContactConstraint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class ContactConstraintSolver {
    protected World world;
    protected List<ContactConstraint> contactConstraints = null;

    public ContactConstraintSolver(World world) {
        this.world = world;
    }

    public void setup(List<ContactConstraint> list) {
        this.contactConstraints = list;
        Settings settings = this.world.getSettings();
        double d = settings.getRestitutionVelocity();
        int n = this.contactConstraints.size();
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4;
            Contact contact;
            ContactConstraint contactConstraint = this.contactConstraints.get(i);
            Body body = contactConstraint.getBody1();
            Body body2 = contactConstraint.getBody2();
            Transform transform = body.getTransform();
            Transform transform2 = body2.getTransform();
            Mass mass = body.getMass();
            Mass mass2 = body2.getMass();
            double d5 = mass.getInverseMass();
            double d6 = mass2.getInverseMass();
            double d7 = mass.getInverseInertia();
            double d8 = mass2.getInverseInertia();
            Vector2 vector2 = transform.getTransformed(mass.getCenter());
            Vector2 vector22 = transform2.getTransformed(mass2.getCenter());
            List<Contact> list2 = contactConstraint.contacts;
            Iterator<Contact> iterator = list2.iterator();
            while (iterator.hasNext()) {
                Contact contact2 = iterator.next();
                if (contact2.enabled) continue;
                iterator.remove();
            }
            int n2 = list2.size();
            Vector2 vector23 = contactConstraint.normal;
            Vector2 vector24 = contactConstraint.tangent;
            for (int j = 0; j < n2; ++j) {
                Vector2 vector25;
                contact = list2.get(j);
                Vector2 vector26 = vector2.to(contact.p);
                Vector2 vector27 = vector22.to(contact.p);
                contact.r1 = vector26;
                contact.r2 = vector27;
                d4 = vector26.cross(vector23);
                d3 = vector27.cross(vector23);
                contact.massN = 1.0 / (d5 + d6 + d7 * d4 * d4 + d8 * d3 * d3);
                d2 = vector26.cross(vector24);
                double d9 = vector27.cross(vector24);
                contact.massT = 1.0 / (d5 + d6 + d7 * d2 * d2 + d8 * d9 * d9);
                contact.vb = 0.0;
                Vector2 vector28 = vector26.cross(body.getAngularVelocity()).add(body.getLinearVelocity());
                Vector2 vector29 = vector28.subtract(vector25 = vector27.cross(body2.getAngularVelocity()).add(body2.getLinearVelocity()));
                double d10 = vector23.dot(vector29);
                if (!(d10 < -d)) continue;
                contact.vb += -contactConstraint.restitution * d10;
            }
            if (n2 != 2) continue;
            Contact contact3 = list2.get(0);
            contact = list2.get(1);
            double d11 = contact3.r1.cross(vector23);
            d4 = contact3.r2.cross(vector23);
            d3 = contact.r1.cross(vector23);
            d2 = contact.r2.cross(vector23);
            Matrix22 matrix22 = new Matrix22();
            matrix22.m00 = d5 + d6 + d7 * d11 * d11 + d8 * d4 * d4;
            matrix22.m10 = matrix22.m01 = d5 + d6 + d7 * d11 * d3 + d8 * d4 * d2;
            matrix22.m11 = d5 + d6 + d7 * d3 * d3 + d8 * d2 * d2;
            if (matrix22.m00 * matrix22.m00 < 1000.0 * matrix22.determinant()) {
                contactConstraint.K = matrix22;
                contactConstraint.invK = matrix22.getInverse();
                continue;
            }
            if (contact3.depth > contact.depth) {
                contactConstraint.contacts.remove(1);
                continue;
            }
            contactConstraint.contacts.remove(0);
        }
    }

    public void initializeConstraints(Step step) {
        double d = 1.0 / step.getDeltaTimeRatio();
        int n = this.contactConstraints.size();
        for (int i = 0; i < n; ++i) {
            ContactConstraint contactConstraint = this.contactConstraints.get(i);
            Body body = contactConstraint.getBody1();
            Body body2 = contactConstraint.getBody2();
            Mass mass = body.getMass();
            Mass mass2 = body2.getMass();
            double d2 = mass.getInverseMass();
            double d3 = mass2.getInverseMass();
            double d4 = mass.getInverseInertia();
            double d5 = mass2.getInverseInertia();
            Vector2 vector2 = contactConstraint.normal;
            Vector2 vector22 = contactConstraint.tangent;
            List<Contact> list = contactConstraint.getContacts();
            int n2 = list.size();
            if (n2 == 0) continue;
            for (int j = 0; j < n2; ++j) {
                Contact contact = list.get(j);
                contact.jn *= d;
                contact.jt *= d;
                Vector2 vector23 = new Vector2(vector2.x * contact.jn + vector22.x * contact.jt, vector2.y * contact.jn + vector22.y * contact.jt);
                body.getLinearVelocity().add(vector23.x * d2, vector23.y * d2);
                body.setAngularVelocity(body.getAngularVelocity() + d4 * contact.r1.cross(vector23));
                body2.getLinearVelocity().subtract(vector23.x * d3, vector23.y * d3);
                body2.setAngularVelocity(body2.getAngularVelocity() - d5 * contact.r2.cross(vector23));
            }
        }
    }

    public void solveVelocityContraints() {
        int n = this.contactConstraints.size();
        for (int i = 0; i < n; ++i) {
            Vector2 vector2;
            Vector2 vector22;
            Vector2 vector23;
            Vector2 vector24;
            double d;
            double d2;
            Contact contact;
            Vector2 vector25;
            Vector2 vector26;
            Vector2 vector27;
            Vector2 vector28;
            Vector2 vector29;
            Object object;
            ContactConstraint contactConstraint = this.contactConstraints.get(i);
            Body body = contactConstraint.getBody1();
            Body body2 = contactConstraint.getBody2();
            Mass mass = body.getMass();
            Mass mass2 = body2.getMass();
            double d3 = mass.getInverseMass();
            double d4 = mass2.getInverseMass();
            double d5 = mass.getInverseInertia();
            double d6 = mass2.getInverseInertia();
            List<Contact> list = contactConstraint.contacts;
            int n2 = list.size();
            if (n2 == 0) continue;
            Vector2 vector210 = contactConstraint.normal;
            Vector2 vector211 = contactConstraint.tangent;
            double d7 = contactConstraint.tangentSpeed;
            for (int j = 0; j < n2; ++j) {
                object = list.get(j);
                vector29 = ((Contact)object).r1;
                vector28 = ((Contact)object).r2;
                vector27 = vector29.cross(body.getAngularVelocity()).add(body.getLinearVelocity());
                vector26 = vector28.cross(body2.getAngularVelocity()).add(body2.getLinearVelocity());
                vector25 = vector27.subtract(vector26);
                double d8 = vector211.dot(vector25) - d7;
                double d9 = ((Contact)object).massT * -d8;
                double d10 = contactConstraint.friction * ((Contact)object).jn;
                double d11 = ((Contact)object).jt;
                ((Contact)object).jt = Math.max(-d10, Math.min(d11 + d9, d10));
                d9 = ((Contact)object).jt - d11;
                Vector2 vector212 = new Vector2(vector211.x * d9, vector211.y * d9);
                body.getLinearVelocity().add(vector212.x * d3, vector212.y * d3);
                body.setAngularVelocity(body.getAngularVelocity() + d5 * vector29.cross(vector212));
                body2.getLinearVelocity().subtract(vector212.x * d4, vector212.y * d4);
                body2.setAngularVelocity(body2.getAngularVelocity() - d6 * vector28.cross(vector212));
            }
            if (n2 == 1) {
                contact = list.get(0);
                object = contact.r1;
                vector29 = contact.r2;
                vector28 = ((Vector2)object).cross(body.getAngularVelocity()).add(body.getLinearVelocity());
                vector27 = vector29.cross(body2.getAngularVelocity()).add(body2.getLinearVelocity());
                vector26 = vector28.subtract(vector27);
                double d12 = vector210.dot(vector26);
                d2 = -contact.massN * (d12 - contact.vb);
                d = contact.jn;
                contact.jn = Math.max(d + d2, 0.0);
                d2 = contact.jn - d;
                vector24 = new Vector2(vector210.x * d2, vector210.y * d2);
                body.getLinearVelocity().add(vector24.x * d3, vector24.y * d3);
                body.setAngularVelocity(body.getAngularVelocity() + d5 * ((Vector2)object).cross(vector24));
                body2.getLinearVelocity().subtract(vector24.x * d4, vector24.y * d4);
                body2.setAngularVelocity(body2.getAngularVelocity() - d6 * vector29.cross(vector24));
                continue;
            }
            contact = list.get(0);
            object = list.get(1);
            vector29 = contact.r1;
            vector28 = contact.r2;
            vector27 = ((Contact)object).r1;
            vector26 = ((Contact)object).r2;
            vector25 = body.getLinearVelocity();
            Vector2 vector213 = body2.getLinearVelocity();
            d2 = body.getAngularVelocity();
            d = body2.getAngularVelocity();
            vector24 = new Vector2(contact.jn, ((Contact)object).jn);
            Vector2 vector214 = new Vector2();
            vector214.x = -vector29.y * d2 + vector25.x + vector28.y * d - vector213.x;
            vector214.y = vector29.x * d2 + vector25.y - vector28.x * d - vector213.y;
            Vector2 vector215 = new Vector2();
            vector215.x = -vector27.y * d2 + vector25.x + vector26.y * d - vector213.x;
            vector215.y = vector27.x * d2 + vector25.y - vector26.x * d - vector213.y;
            double d13 = vector210.dot(vector214);
            double d14 = vector210.dot(vector215);
            Vector2 vector216 = new Vector2();
            vector216.x = d13 - contact.vb;
            vector216.y = d14 - ((Contact)object).vb;
            vector216.subtract(contactConstraint.K.product(vector24));
            Vector2 vector217 = contactConstraint.invK.product(vector216).negate();
            if (vector217.x >= 0.0 && vector217.y >= 0.0) {
                vector23 = vector217.difference(vector24);
                vector22 = vector210.product(vector23.x);
                vector2 = vector210.product(vector23.y);
                vector25.add(vector22.sum(vector2).multiply(d3));
                body.setAngularVelocity(d2 + d5 * (vector29.cross(vector22) + vector27.cross(vector2)));
                vector213.subtract(vector22.sum(vector2).multiply(d4));
                body2.setAngularVelocity(d - d6 * (vector28.cross(vector22) + vector26.cross(vector2)));
                contact.jn = vector217.x;
                ((Contact)object).jn = vector217.y;
                continue;
            }
            vector217.x = -contact.massN * vector216.x;
            vector217.y = 0.0;
            d13 = 0.0;
            d14 = contactConstraint.K.m10 * vector217.x + vector216.y;
            if (vector217.x >= 0.0 && d14 >= 0.0) {
                vector23 = vector217.difference(vector24);
                vector22 = vector210.product(vector23.x);
                vector2 = vector210.product(vector23.y);
                vector25.add(vector22.sum(vector2).multiply(d3));
                body.setAngularVelocity(d2 + d5 * (vector29.cross(vector22) + vector27.cross(vector2)));
                vector213.subtract(vector22.sum(vector2).multiply(d4));
                body2.setAngularVelocity(d - d6 * (vector28.cross(vector22) + vector26.cross(vector2)));
                contact.jn = vector217.x;
                ((Contact)object).jn = vector217.y;
                continue;
            }
            vector217.x = 0.0;
            vector217.y = -((Contact)object).massN * vector216.y;
            d13 = contactConstraint.K.m01 * vector217.y + vector216.x;
            d14 = 0.0;
            if (vector217.y >= 0.0 && d13 >= 0.0) {
                vector23 = vector217.difference(vector24);
                vector22 = vector210.product(vector23.x);
                vector2 = vector210.product(vector23.y);
                vector25.add(vector22.sum(vector2).multiply(d3));
                body.setAngularVelocity(d2 + d5 * (vector29.cross(vector22) + vector27.cross(vector2)));
                vector213.subtract(vector22.sum(vector2).multiply(d4));
                body2.setAngularVelocity(d - d6 * (vector28.cross(vector22) + vector26.cross(vector2)));
                contact.jn = vector217.x;
                ((Contact)object).jn = vector217.y;
                continue;
            }
            vector217.x = 0.0;
            vector217.y = 0.0;
            d13 = vector216.x;
            d14 = vector216.y;
            if (!(d13 >= 0.0) || !(d14 >= 0.0)) continue;
            vector23 = vector217.difference(vector24);
            vector22 = vector210.product(vector23.x);
            vector2 = vector210.product(vector23.y);
            vector25.add(vector22.sum(vector2).multiply(d3));
            body.setAngularVelocity(d2 + d5 * (vector29.cross(vector22) + vector27.cross(vector2)));
            vector213.subtract(vector22.sum(vector2).multiply(d4));
            body2.setAngularVelocity(d - d6 * (vector28.cross(vector22) + vector26.cross(vector2)));
            contact.jn = vector217.x;
            ((Contact)object).jn = vector217.y;
        }
    }

    public boolean solvePositionContraints() {
        if (this.contactConstraints.isEmpty()) {
            return true;
        }
        double d = 0.0;
        Settings settings = this.world.getSettings();
        double d2 = settings.getMaximumLinearCorrection();
        double d3 = settings.getLinearTolerance();
        double d4 = settings.getBaumgarte();
        int n = this.contactConstraints.size();
        for (int i = 0; i < n; ++i) {
            ContactConstraint contactConstraint = this.contactConstraints.get(i);
            Body body = contactConstraint.getBody1();
            Body body2 = contactConstraint.getBody2();
            Transform transform = body.getTransform();
            Transform transform2 = body2.getTransform();
            Mass mass = body.getMass();
            Mass mass2 = body2.getMass();
            double d5 = mass.getMass();
            double d6 = mass2.getMass();
            List<Contact> list = contactConstraint.contacts;
            int n2 = list.size();
            if (n2 == 0) continue;
            Vector2 vector2 = contactConstraint.normal;
            double d7 = d5 * mass.getInverseMass();
            double d8 = d5 * mass.getInverseInertia();
            double d9 = d6 * mass2.getInverseMass();
            double d10 = d6 * mass2.getInverseInertia();
            for (int j = 0; j < n2; ++j) {
                Contact contact = list.get(j);
                Vector2 vector22 = transform.getTransformed(mass.getCenter());
                Vector2 vector23 = transform2.getTransformed(mass2.getCenter());
                Vector2 vector24 = contact.p1.difference(mass.getCenter());
                transform.transformR(vector24);
                Vector2 vector25 = contact.p2.difference(mass2.getCenter());
                transform2.transformR(vector25);
                Vector2 vector26 = vector22.sum(vector24);
                Vector2 vector27 = vector23.sum(vector25);
                Vector2 vector28 = vector26.subtract(vector27);
                double d11 = vector28.dot(vector2) - contact.depth;
                d = Math.min(d, d11);
                double d12 = d4 * Interval.clamp(d11 + d3, -d2, 0.0);
                double d13 = vector24.cross(vector2);
                double d14 = vector25.cross(vector2);
                double d15 = d7 + d9 + d8 * d13 * d13 + d10 * d14 * d14;
                double d16 = 0.0;
                if (d15 > Epsilon.E) {
                    d16 = -d12 / d15;
                }
                double d17 = contact.jp;
                contact.jp = Math.max(d17 + d16, 0.0);
                d16 = contact.jp - d17;
                Vector2 vector29 = vector2.product(d16);
                body.translate(vector29.product(d7));
                body.rotate(d8 * vector24.cross(vector29), vector22.x, vector22.y);
                body2.translate(vector29.product(-d9));
                body2.rotate(-d10 * vector25.cross(vector29), vector23.x, vector23.y);
            }
        }
        return d >= -3.0 * d3;
    }
}

