/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.contact;

import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.BodyFixture;
import org.dyn4j.dynamics.contact.ContactPointId;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class ContactPoint {
    protected ContactPointId id;
    protected Body body1;
    protected Body body2;
    protected BodyFixture fixture1;
    protected BodyFixture fixture2;
    protected boolean enabled;
    protected Vector2 point;
    protected Vector2 normal;
    protected double depth;

    public ContactPoint() {
    }

    public ContactPoint(ContactPointId contactPointId, Body body, BodyFixture bodyFixture, Body body2, BodyFixture bodyFixture2, boolean bl, Vector2 vector2, Vector2 vector22, double d) {
        this.id = contactPointId;
        this.body1 = body;
        this.fixture1 = bodyFixture;
        this.body2 = body2;
        this.fixture2 = bodyFixture2;
        this.enabled = bl;
        this.point = vector2;
        this.normal = vector22;
        this.depth = d;
    }

    public ContactPoint(ContactPoint contactPoint) {
        if (contactPoint == null) {
            throw new NullPointerException(Messages.getString("dynamics.contact.contactPoint.nullContactPoint"));
        }
        this.id = contactPoint.id;
        this.body1 = contactPoint.body1;
        this.fixture1 = contactPoint.fixture1;
        this.body2 = contactPoint.body2;
        this.fixture2 = contactPoint.fixture2;
        this.enabled = contactPoint.enabled;
        this.point = contactPoint.point;
        this.normal = contactPoint.normal;
        this.depth = contactPoint.depth;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ContactPoint[Id=").append(this.id).append("|Body1=").append(this.body1).append("|Fixture1=").append(this.fixture1).append("|Body2=").append(this.body2).append("|Fixture2=").append(this.fixture2).append("|IsEnabled=").append(this.enabled).append("|Point=").append(this.point).append("|Normal=").append(this.normal).append("|Depth=").append(this.depth).append("]");
        return stringBuilder.toString();
    }

    public ContactPointId getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Vector2 getPoint() {
        return this.point;
    }

    public Vector2 getNormal() {
        return this.normal;
    }

    public double getDepth() {
        return this.depth;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    public BodyFixture getFixture1() {
        return this.fixture1;
    }

    public BodyFixture getFixture2() {
        return this.fixture2;
    }
}

