/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class AngleJoint
extends Joint {
    protected double ratio;
    protected double lowerLimit;
    protected double upperLimit;
    protected boolean limitEnabled;
    protected double referenceAngle;
    protected double invK;
    protected Joint.LimitState limitState;
    protected double impulse;

    public AngleJoint(Body body, Body body2) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        this.ratio = 1.0;
        this.impulse = 0.0;
        this.upperLimit = this.referenceAngle = body.getTransform().getRotation() - body2.getTransform().getRotation();
        this.lowerLimit = this.referenceAngle;
        this.limitEnabled = true;
        this.limitState = Joint.LimitState.EQUAL;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AngleJoint[").append(super.toString()).append("|Ratio=").append(this.ratio).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("|IsLimitEnabled=").append(this.limitEnabled).append("|ReferenceAngle=").append(this.referenceAngle).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getAngularTolerance();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseInertia();
        double d3 = mass2.getInverseInertia();
        if (this.limitEnabled) {
            double d4 = this.getRelativeRotation();
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d) {
                this.limitState = Joint.LimitState.EQUAL;
            } else if (this.upperLimit > this.lowerLimit) {
                if (d4 >= this.upperLimit) {
                    if (this.limitState != Joint.LimitState.AT_UPPER) {
                        this.impulse = 0.0;
                    }
                    this.limitState = Joint.LimitState.AT_UPPER;
                } else if (d4 <= this.lowerLimit) {
                    if (this.limitState != Joint.LimitState.AT_LOWER) {
                        this.impulse = 0.0;
                    }
                    this.limitState = Joint.LimitState.AT_LOWER;
                } else {
                    this.limitState = Joint.LimitState.INACTIVE;
                    this.impulse = 0.0;
                }
            }
        } else {
            this.limitState = Joint.LimitState.INACTIVE;
            this.impulse = 0.0;
        }
        this.invK = this.limitState == Joint.LimitState.INACTIVE ? d2 + this.ratio * this.ratio * d3 : d2 + d3;
        if (this.invK > Epsilon.E) {
            this.invK = 1.0 / this.invK;
        }
        this.impulse *= step.getDeltaTimeRatio();
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d2 * this.impulse);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d3 * this.impulse * (this.limitState == Joint.LimitState.INACTIVE ? this.ratio : 1.0));
    }

    @Override
    public void solveVelocityConstraints() {
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseInertia();
        double d2 = mass2.getInverseInertia();
        if (this.limitState != Joint.LimitState.INACTIVE) {
            double d3;
            double d4 = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            double d5 = this.invK * -d4;
            if (this.limitState == Joint.LimitState.EQUAL) {
                this.impulse += d5;
            } else if (this.limitState == Joint.LimitState.AT_LOWER) {
                double d6 = this.impulse + d5;
                if (d6 < 0.0) {
                    d5 = -this.impulse;
                    this.impulse = 0.0;
                }
            } else if (this.limitState == Joint.LimitState.AT_UPPER && (d3 = this.impulse + d5) > 0.0) {
                d5 = -this.impulse;
                this.impulse = 0.0;
            }
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d * d5);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d2 * d5);
        } else if (this.ratio != 1.0) {
            double d7 = this.body1.getAngularVelocity() - this.ratio * this.body2.getAngularVelocity();
            double d8 = this.invK * -d7;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d * d8);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d2 * d8 * this.ratio);
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        if (this.limitState != Joint.LimitState.INACTIVE) {
            Settings settings = this.world.getSettings();
            double d = settings.getAngularTolerance();
            double d2 = settings.getMaximumAngularCorrection();
            Mass mass = this.body1.getMass();
            Mass mass2 = this.body2.getMass();
            double d3 = mass.getInverseInertia();
            double d4 = mass2.getInverseInertia();
            double d5 = this.getRelativeRotation();
            double d6 = 0.0;
            double d7 = 0.0;
            if (this.limitState == Joint.LimitState.EQUAL) {
                double d8 = Interval.clamp(d5 - this.lowerLimit, -d2, d2);
                d6 = -d8 * this.invK;
                d7 = Math.abs(d8);
            } else if (this.limitState == Joint.LimitState.AT_LOWER) {
                double d9 = d5 - this.lowerLimit;
                d7 = -d9;
                d9 = Interval.clamp(d9 + d, -d2, 0.0);
                d6 = -d9 * this.invK;
            } else if (this.limitState == Joint.LimitState.AT_UPPER) {
                double d10;
                d7 = d10 = d5 - this.upperLimit;
                d10 = Interval.clamp(d10 - d, 0.0, d2);
                d6 = -d10 * this.invK;
            }
            this.body1.rotateAboutCenter(d3 * d6);
            this.body2.rotateAboutCenter(-d4 * d6);
            return d7 <= d;
        }
        return true;
    }

    private double getRelativeRotation() {
        double d = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldCenter();
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldCenter();
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return new Vector2();
    }

    @Override
    public double getReactionTorque(double d) {
        return this.impulse * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getJointAngle() {
        return this.getRelativeRotation();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        this.ratio = d;
    }

    public void setLimitEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.limitEnabled = bl;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double d) {
        if (d < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = d;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double d) {
        if (d > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = d;
    }

    public void setLimits(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = d2;
        this.lowerLimit = d;
    }

    public void setLimitsEnabled(double d, double d2) {
        this.setLimits(d, d2);
        this.limitEnabled = true;
    }

    public void setLimits(double d) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = d;
        this.lowerLimit = d;
    }

    public void setLimitsEnabled(double d) {
        this.setLimits(d);
        this.limitEnabled = true;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double d) {
        this.referenceAngle = d;
    }
}

