/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class FrictionJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double maximumForce;
    protected double maximumTorque;
    protected Matrix22 K;
    protected double angularMass;
    protected Vector2 linearImpulse;
    protected double angularImpulse;

    public FrictionJoint(Body body, Body body2, Vector2 vector2) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        this.K = new Matrix22();
        this.linearImpulse = new Vector2();
        this.angularImpulse = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FrictionJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|MaximumForce=").append(this.maximumForce).append("|MaximumTorque=").append(this.maximumTorque).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = d + d2 + vector2.y * vector2.y * d3 + vector22.y * vector22.y * d4;
        this.K.m10 = this.K.m01 = -d3 * vector2.x * vector2.y - d4 * vector22.x * vector22.y;
        this.K.m11 = d + d2 + vector2.x * vector2.x * d3 + vector22.x * vector22.x * d4;
        this.angularMass = d3 + d4;
        if (this.angularMass > Epsilon.E) {
            this.angularMass = 1.0 / this.angularMass;
        }
        this.linearImpulse.multiply(step.getDeltaTimeRatio());
        this.angularImpulse *= step.getDeltaTimeRatio();
        this.body1.getLinearVelocity().add(this.linearImpulse.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * (vector2.cross(this.linearImpulse) + this.angularImpulse));
        this.body2.getLinearVelocity().subtract(this.linearImpulse.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * (vector22.cross(this.linearImpulse) + this.angularImpulse));
    }

    @Override
    public void solveVelocityConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        double d5 = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
        double d6 = this.angularMass * -d5;
        double d7 = this.angularImpulse;
        double d8 = this.maximumTorque * step.getDeltaTime();
        this.angularImpulse = Interval.clamp(this.angularImpulse + d6, -d8, d8);
        d6 = this.angularImpulse - d7;
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * d6);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * d6);
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
        Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
        Vector2 vector25 = vector23.subtract(vector24);
        Vector2 vector26 = this.K.solve(vector25.negate());
        Vector2 vector27 = this.linearImpulse.copy();
        this.linearImpulse.add(vector26);
        double d9 = this.maximumForce * step.getDeltaTime();
        if (this.linearImpulse.getMagnitudeSquared() > d9 * d9) {
            this.linearImpulse.normalize();
            this.linearImpulse.multiply(d9);
        }
        vector26 = this.linearImpulse.difference(vector27);
        this.body1.getLinearVelocity().add(vector26.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector26));
        this.body2.getLinearVelocity().subtract(vector26.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * vector22.cross(vector26));
    }

    @Override
    public boolean solvePositionConstraints() {
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.linearImpulse.product(d);
    }

    @Override
    public double getReactionTorque(double d) {
        return this.angularImpulse * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getMaximumTorque() {
        return this.maximumTorque;
    }

    public void setMaximumTorque(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumTorque"));
        }
        this.maximumTorque = d;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumForce"));
        }
        this.maximumForce = d;
    }
}

