/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import java.util.UUID;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Constraint;
import org.dyn4j.geometry.Vector2;

public abstract class Joint
extends Constraint {
    protected UUID id = UUID.randomUUID();
    protected boolean collisionAllowed;

    public Joint(Body body, Body body2) {
        this(body, body2, false);
    }

    public Joint(Body body, Body body2, boolean bl) {
        super(body, body2);
        this.collisionAllowed = bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Id=").append(this.id).append("|").append(super.toString()).append("|IsCollisionAllowed=").append(this.collisionAllowed);
        return stringBuilder.toString();
    }

    public abstract void initializeConstraints();

    public abstract void solveVelocityConstraints();

    public abstract boolean solvePositionConstraints();

    public abstract Vector2 getAnchor1();

    public abstract Vector2 getAnchor2();

    public abstract Vector2 getReactionForce(double var1);

    public abstract double getReactionTorque(double var1);

    public UUID getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.body1.isActive() && this.body2.isActive();
    }

    public boolean isCollisionAllowed() {
        return this.collisionAllowed;
    }

    public void setCollisionAllowed(boolean bl) {
        if (this.collisionAllowed != bl) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.collisionAllowed = bl;
        }
    }

    public static enum LimitState {
        EQUAL,
        AT_LOWER,
        AT_UPPER,
        INACTIVE;

    }
}

