/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

@Deprecated
public class LineJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorForce;
    protected boolean limitEnabled;
    protected double upperLimit;
    protected double lowerLimit;
    protected Matrix22 K;
    protected double motorMass;
    protected Joint.LimitState limitState;
    protected Vector2 impulse;
    protected double motorImpulse;
    protected Vector2 xAxis;
    protected Vector2 yAxis;
    protected Vector2 perp;
    protected Vector2 axis;
    protected double s1;
    protected double s2;
    protected double a1;
    protected double a2;

    public LineJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAxis"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        Vector2 vector23 = vector22.getNormalized();
        this.xAxis = body2.getLocalVector(vector23);
        this.yAxis = this.xAxis.cross(1.0);
        this.K = new Matrix22();
        this.impulse = new Vector2();
        this.limitEnabled = false;
        this.motorEnabled = false;
        this.limitState = Joint.LimitState.INACTIVE;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LineJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|XAxis=").append(this.xAxis).append("|YAxis=").append(this.yAxis).append("|Axis=").append(this.getAxis()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorForce=").append(this.maximumMotorForce).append("|IsLimitEnabled=").append(this.limitEnabled).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getWorldCenter().sum(vector2).subtract(this.body2.getWorldCenter().sum(vector22));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        this.s1 = vector2.cross(this.perp);
        this.s2 = vector22.sum(vector23).cross(this.perp);
        this.a1 = vector2.cross(this.axis);
        this.a2 = vector22.sum(vector23).cross(this.axis);
        this.K.m00 = d2 + d3 + this.s1 * this.s1 * d4 + this.s2 * this.s2 * d5;
        this.K.m10 = this.K.m01 = this.s1 * this.a1 * d4 + this.s2 * this.a2 * d5;
        this.motorMass = this.K.m11 = d2 + d3 + this.a1 * this.a1 * d4 + this.a2 * this.a2 * d5;
        if (Math.abs(this.motorMass) > Epsilon.E) {
            this.motorMass = 1.0 / this.motorMass;
        }
        if (!this.motorEnabled) {
            this.motorImpulse = 0.0;
        }
        if (this.limitEnabled) {
            double d6 = this.axis.dot(vector23);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d) {
                this.limitState = Joint.LimitState.EQUAL;
            } else if (d6 <= this.lowerLimit) {
                if (this.limitState != Joint.LimitState.AT_LOWER) {
                    this.limitState = Joint.LimitState.AT_LOWER;
                    this.impulse.y = 0.0;
                }
            } else if (d6 >= this.upperLimit) {
                if (this.limitState != Joint.LimitState.AT_UPPER) {
                    this.limitState = Joint.LimitState.AT_UPPER;
                    this.impulse.y = 0.0;
                }
            } else {
                this.limitState = Joint.LimitState.INACTIVE;
                this.impulse.y = 0.0;
            }
        } else {
            this.limitState = Joint.LimitState.INACTIVE;
            this.impulse.y = 0.0;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 vector24 = new Vector2();
        vector24.x = this.perp.x * this.impulse.x + (this.motorImpulse + this.impulse.y) * this.axis.x;
        vector24.y = this.perp.y * this.impulse.x + (this.motorImpulse + this.impulse.y) * this.axis.y;
        double d7 = this.impulse.x * this.s1 + (this.motorImpulse + this.impulse.y) * this.a1;
        double d8 = this.impulse.x * this.s2 + (this.motorImpulse + this.impulse.y) * this.a2;
        this.body1.getVelocity().add(vector24.product(d2));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d4 * d7);
        this.body2.getVelocity().subtract(vector24.product(d3));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d5 * d8);
    }

    @Override
    public void solveVelocityConstraints() {
        double d;
        double d2;
        double d3;
        Step step = this.world.getStep();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d4 = mass.getInverseMass();
        double d5 = mass2.getInverseMass();
        double d6 = mass.getInverseInertia();
        double d7 = mass2.getInverseInertia();
        Vector2 vector2 = this.body1.getVelocity();
        Vector2 vector22 = this.body2.getVelocity();
        double d8 = this.body1.getAngularVelocity();
        double d9 = this.body2.getAngularVelocity();
        if (this.motorEnabled && this.limitState != Joint.LimitState.EQUAL) {
            d3 = this.axis.dot(vector2.difference(vector22)) + this.a1 * d8 - this.a2 * d9;
            d2 = this.motorMass * (this.motorSpeed - d3);
            double d10 = this.motorImpulse;
            double d11 = this.maximumMotorForce * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + d2, -d11, d11);
            d2 = this.motorImpulse - d10;
            Vector2 vector23 = this.axis.product(d2);
            d = d2 * this.a1;
            double d12 = d2 * this.a2;
            vector2.add(vector23.product(d4));
            d8 += d * d6;
            vector22.subtract(vector23.product(d5));
            d9 -= d12 * d7;
        }
        d3 = this.perp.dot(vector2.difference(vector22)) + this.s1 * d8 - this.s2 * d9;
        if (this.limitEnabled && this.limitState != Joint.LimitState.INACTIVE) {
            d2 = this.axis.dot(vector2.difference(vector22)) + this.a1 * d8 - this.a2 * d9;
            Vector2 vector24 = new Vector2(d3, d2);
            Vector2 vector25 = this.K.solve(vector24.negate());
            Vector2 vector26 = this.impulse.copy();
            this.impulse.add(vector25);
            if (this.limitState == Joint.LimitState.AT_LOWER) {
                this.impulse.y = Math.max(this.impulse.y, 0.0);
            } else if (this.limitState == Joint.LimitState.AT_UPPER) {
                this.impulse.y = Math.min(this.impulse.y, 0.0);
            }
            double d13 = -d3 - (this.impulse.y - vector26.y) * this.K.m01;
            d = Math.abs(this.K.m00) > Epsilon.E ? d13 / this.K.m00 + vector26.x : vector26.x;
            this.impulse.x = d;
            vector25 = this.impulse.difference(vector26);
            Vector2 vector27 = new Vector2();
            vector27.x = this.perp.x * vector25.x + vector25.y * this.axis.x;
            vector27.y = this.perp.y * vector25.x + vector25.y * this.axis.y;
            double d14 = vector25.x * this.s1 + vector25.y * this.a1;
            double d15 = vector25.x * this.s2 + vector25.y * this.a2;
            vector2.add(vector27.product(d4));
            d8 += d14 * d6;
            vector22.subtract(vector27.product(d5));
            d9 -= d15 * d7;
        } else {
            d2 = Math.abs(this.K.m00) > Epsilon.E ? -d3 / this.K.m00 : 0.0;
            this.impulse.x += d2;
            Vector2 vector28 = this.perp.product(d2);
            double d16 = d2 * this.s1;
            double d17 = d2 * this.s2;
            vector2.add(vector28.product(d4));
            d8 += d16 * d6;
            vector22.subtract(vector28.product(d5));
            d9 -= d17 * d7;
        }
        this.body1.setAngularVelocity(d8);
        this.body2.setAngularVelocity(d9);
    }

    @Override
    public boolean solvePositionConstraints() {
        Vector2 vector2;
        Vector2 vector22;
        Settings settings = this.world.getSettings();
        double d = settings.getMaximumLinearCorrection();
        double d2 = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        Vector2 vector23 = this.body1.getWorldCenter();
        Vector2 vector24 = this.body2.getWorldCenter();
        Vector2 vector25 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector26 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector27 = vector23.sum(vector25).subtract(vector24.sum(vector26));
        this.axis = this.body2.getWorldVector(this.xAxis);
        this.perp = this.body2.getWorldVector(this.yAxis);
        double d7 = this.perp.dot(vector27);
        double d8 = 0.0;
        double d9 = 0.0;
        boolean bl = false;
        if (this.limitEnabled) {
            this.a1 = vector25.cross(this.axis);
            this.a2 = vector26.sum(vector27).cross(this.axis);
            double d10 = this.axis.dot(vector27);
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d2) {
                d8 = Interval.clamp(d10, -d, d);
                d9 = Math.abs(d10);
                bl = true;
            } else if (d10 <= this.lowerLimit) {
                d8 = Interval.clamp(d10 - this.lowerLimit + d2, -d, 0.0);
                d9 = this.lowerLimit - d10;
                bl = true;
            } else if (d10 >= this.upperLimit) {
                d8 = Interval.clamp(d10 - this.upperLimit - d2, 0.0, d);
                d9 = d10 - this.upperLimit;
                bl = true;
            }
        }
        this.s1 = vector25.cross(this.perp);
        this.s2 = vector26.sum(vector27).cross(this.perp);
        d9 = Math.max(d9, Math.abs(d7));
        if (bl) {
            this.K.m00 = d3 + d4 + this.s1 * this.s1 * d5 + this.s2 * this.s2 * d6;
            this.K.m10 = this.K.m01 = this.s1 * this.a1 * d5 + this.s2 * this.a2 * d6;
            this.K.m11 = d3 + d4 + this.a1 * this.a1 * d5 + this.a2 * this.a2 * d6;
            vector22 = new Vector2(d7, d8);
            vector2 = this.K.solve(vector22.negate());
        } else {
            double d11 = d3 + d4 + this.s1 * this.s1 * d5 + this.s2 * this.s2 * d6;
            if (Math.abs(d11) > Epsilon.E) {
                d11 = 1.0 / d11;
            }
            double d12 = -d11 * d7;
            vector2 = new Vector2(d12, 0.0);
        }
        vector22 = new Vector2();
        vector22.x = this.perp.x * vector2.x + vector2.y * this.axis.x;
        vector22.y = this.perp.y * vector2.x + vector2.y * this.axis.y;
        double d13 = vector2.x * this.s1 + vector2.y * this.a1;
        double d14 = vector2.x * this.s2 + vector2.y * this.a2;
        this.body1.translate(vector22.product(d3));
        this.body1.rotateAboutCenter(d13 * d5);
        this.body2.translate(vector22.product(-d4));
        this.body2.rotateAboutCenter(-d14 * d6);
        return d9 <= d2;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        Vector2 vector2 = new Vector2();
        vector2.x = this.impulse.x * this.perp.x + (this.motorImpulse + this.impulse.y) * this.axis.x;
        vector2.y = this.impulse.x * this.perp.y + (this.motorImpulse + this.impulse.y) * this.axis.y;
        vector2.multiply(d);
        return vector2;
    }

    @Override
    public double getReactionTorque(double d) {
        return 0.0;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public Vector2 getAxis() {
        return this.body2.getWorldVector(this.xAxis);
    }

    public double getJointSpeed() {
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Vector2 vector2 = this.body1.getWorldCenter();
        Vector2 vector22 = this.body2.getWorldCenter();
        Vector2 vector23 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector24 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector25 = vector2.sum(vector23).subtract(vector22.sum(vector24));
        Vector2 vector26 = this.body2.getWorldVector(this.xAxis);
        Vector2 vector27 = this.body1.getVelocity();
        Vector2 vector28 = this.body2.getVelocity();
        double d = this.body1.getAngularVelocity();
        double d2 = this.body2.getAngularVelocity();
        double d3 = vector25.dot(vector26.cross(d2)) + vector26.dot(vector27.sum(vector23.cross(d)).subtract(vector28.sum(vector24.cross(d2))));
        return d3;
    }

    public double getJointTranslation() {
        Vector2 vector2 = this.body1.getWorldPoint(this.localAnchor1);
        Vector2 vector22 = this.body2.getWorldPoint(this.localAnchor2);
        Vector2 vector23 = vector22.difference(vector2);
        Vector2 vector24 = this.body2.getWorldVector(this.xAxis);
        return vector23.dot(vector24);
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = bl;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double d) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorSpeed = d;
    }

    public double getMaximumMotorForce() {
        return this.maximumMotorForce;
    }

    public void setMaximumMotorForce(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorForce"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.maximumMotorForce = d;
    }

    public double getMotorForce() {
        return this.motorImpulse;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.limitEnabled = bl;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double d) {
        if (d > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = d;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double d) {
        if (d < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.upperLimit = d;
    }

    public void setLimits(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.lowerLimit = d;
        this.upperLimit = d2;
    }

    public void setLimitsEnabled(double d, double d2) {
        this.setLimits(d, d2);
        this.limitEnabled = true;
    }
}

