/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class MotorJoint
extends Joint {
    protected Vector2 linearTarget;
    protected double angularTarget;
    protected double correctionFactor;
    protected double maximumForce;
    protected double maximumTorque;
    protected Matrix22 K;
    protected double angularMass;
    protected Vector2 linearError;
    protected double angularError;
    protected Vector2 linearImpulse;
    protected double angularImpulse;

    public MotorJoint(Body body, Body body2) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        this.linearTarget = body.getLocalPoint(body2.getWorldCenter());
        this.angularTarget = body2.getTransform().getRotation() - body.getTransform().getRotation();
        this.correctionFactor = 0.3;
        this.K = new Matrix22();
        this.linearImpulse = new Vector2();
        this.angularImpulse = 0.0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MotorJoint[").append(super.toString()).append("|LinearTarget=").append(this.linearTarget).append("|AngularTarget=").append(this.angularTarget).append("|CorrectionFactor=").append(this.correctionFactor).append("|MaximumForce=").append(this.maximumForce).append("|MaximumTorque=").append(this.maximumTorque).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().getNegative());
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().getNegative());
        this.K.m00 = d + d2 + vector2.y * vector2.y * d3 + vector22.y * vector22.y * d4;
        this.K.m10 = this.K.m01 = -d3 * vector2.x * vector2.y - d4 * vector22.x * vector22.y;
        this.K.m11 = d + d2 + vector2.x * vector2.x * d3 + vector22.x * vector22.x * d4;
        this.K.invert();
        this.angularMass = d3 + d4;
        if (this.angularMass > Epsilon.E) {
            this.angularMass = 1.0 / this.angularMass;
        }
        Vector2 vector23 = vector2.sum(this.body1.getWorldCenter());
        Vector2 vector24 = vector22.sum(this.body2.getWorldCenter());
        Vector2 vector25 = transform.getTransformedR(this.linearTarget);
        this.linearError = vector24.subtract(vector23).subtract(vector25);
        this.angularError = this.getAngularError();
        this.linearImpulse.multiply(step.getDeltaTimeRatio());
        this.angularImpulse *= step.getDeltaTimeRatio();
        this.body1.getLinearVelocity().subtract(this.linearImpulse.product(d));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - d3 * (vector2.cross(this.linearImpulse) + this.angularImpulse));
        this.body2.getLinearVelocity().add(this.linearImpulse.product(d2));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + d4 * (vector22.cross(this.linearImpulse) + this.angularImpulse));
    }

    @Override
    public void solveVelocityConstraints() {
        Step step = this.world.getStep();
        double d = step.getDeltaTime();
        double d2 = step.getInverseDeltaTime();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        double d7 = this.body2.getAngularVelocity() - this.body1.getAngularVelocity() + d2 * this.correctionFactor * this.angularError;
        double d8 = this.angularMass * -d7;
        double d9 = this.angularImpulse;
        double d10 = this.maximumTorque * d;
        this.angularImpulse = Interval.clamp(this.angularImpulse + d8, -d10, d10);
        d8 = this.angularImpulse - d9;
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - d5 * d8);
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + d6 * d8);
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().getNegative());
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().getNegative());
        Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
        Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
        Vector2 vector25 = vector24.subtract(vector23);
        vector25.add(this.linearError.product(this.correctionFactor * d2));
        Vector2 vector26 = this.K.multiply(vector25);
        vector26.negate();
        Vector2 vector27 = this.linearImpulse.copy();
        this.linearImpulse.add(vector26);
        double d11 = this.maximumForce * d;
        if (this.linearImpulse.getMagnitudeSquared() > d11 * d11) {
            this.linearImpulse.normalize();
            this.linearImpulse.multiply(d11);
        }
        vector26 = this.linearImpulse.difference(vector27);
        this.body1.getLinearVelocity().subtract(vector26.product(d3));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() - d5 * vector2.cross(vector26));
        this.body2.getLinearVelocity().add(vector26.product(d4));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() + d6 * vector22.cross(vector26));
    }

    @Override
    public boolean solvePositionConstraints() {
        return true;
    }

    private double getAngularError() {
        double d = this.body2.getTransform().getRotation() - this.body1.getTransform().getRotation() - this.angularTarget;
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldCenter();
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldCenter();
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.linearImpulse.product(d);
    }

    @Override
    public double getReactionTorque(double d) {
        return this.angularImpulse * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public Vector2 getLinearTarget() {
        return this.linearTarget;
    }

    public void setLinearTarget(Vector2 vector2) {
        if (!vector2.equals(this.linearTarget)) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.linearTarget = vector2;
        }
    }

    public double getAngularTarget() {
        return this.angularTarget;
    }

    public void setAngularTarget(double d) {
        if (d != this.angularTarget) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.angularTarget = d;
        }
    }

    public double getCorrectionFactor() {
        return this.correctionFactor;
    }

    public void setCorrectionFactor(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.motor.invalidCorrectionFactor"));
        }
        this.correctionFactor = d;
    }

    public double getMaximumTorque() {
        return this.maximumTorque;
    }

    public void setMaximumTorque(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumTorque"));
        }
        this.maximumTorque = d;
    }

    public double getMaximumForce() {
        return this.maximumForce;
    }

    public void setMaximumForce(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.friction.invalidMaximumForce"));
        }
        this.maximumForce = d;
    }
}

