/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class PulleyJoint
extends Joint {
    protected Vector2 pulleyAnchor1;
    protected Vector2 pulleyAnchor2;
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected double ratio;
    protected final double length1;
    protected final double length2;
    protected double length;
    protected Vector2 n1;
    protected Vector2 n2;
    protected double invK;
    protected double impulse;
    protected boolean slackEnabled;
    protected Joint.LimitState limitState;

    public PulleyJoint(Body body, Body body2, Vector2 vector2, Vector2 vector22, Vector2 vector23, Vector2 vector24) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullPulleyAnchor1"));
        }
        if (vector22 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullPulleyAnchor2"));
        }
        if (vector23 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullBodyAnchor1"));
        }
        if (vector24 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.pulley.nullBodyAnchor2"));
        }
        this.pulleyAnchor1 = vector2;
        this.pulleyAnchor2 = vector22;
        this.localAnchor1 = body.getLocalPoint(vector23);
        this.localAnchor2 = body2.getLocalPoint(vector24);
        this.ratio = 1.0;
        this.length1 = vector23.distance(vector2);
        this.length2 = vector24.distance(vector22);
        this.length = this.length1 + this.length2;
        this.impulse = 0.0;
        this.slackEnabled = false;
        this.limitState = Joint.LimitState.AT_UPPER;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PulleyJoint[").append(super.toString()).append("|PulleyAnchor1=").append(this.pulleyAnchor1).append("|PulleyAnchor2=").append(this.pulleyAnchor2).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor1=").append(this.getAnchor1()).append("|WorldAnchor2=").append(this.getAnchor2()).append("|Ratio=").append(this.ratio).append("|Length1=").append(this.length1).append("|Length2=").append(this.length2).append("|Length=").append(this.length).append("|SlackEnabled=").append(this.slackEnabled).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        double d;
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d2 = settings.getLinearTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d3 = mass.getInverseMass();
        double d4 = mass2.getInverseMass();
        double d5 = mass.getInverseInertia();
        double d6 = mass2.getInverseInertia();
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = vector2.sum(this.body1.getWorldCenter());
        Vector2 vector24 = vector22.sum(this.body2.getWorldCenter());
        Vector2 vector25 = this.pulleyAnchor1;
        Vector2 vector26 = this.pulleyAnchor2;
        this.n1 = vector25.to(vector23);
        this.n2 = vector26.to(vector24);
        double d7 = this.n1.normalize();
        double d8 = d7 + this.ratio * (d = this.n2.normalize());
        if (d8 > this.length || !this.slackEnabled) {
            this.limitState = Joint.LimitState.AT_UPPER;
            if (d7 <= 10.0 * d2) {
                this.n1.zero();
            }
            if (d <= 10.0 * d2) {
                this.n2.zero();
            }
            double d9 = vector2.cross(this.n1);
            double d10 = vector22.cross(this.n2);
            double d11 = d3 + d5 * d9 * d9;
            double d12 = d4 + d6 * d10 * d10;
            this.invK = d11 + this.ratio * this.ratio * d12;
            this.invK = this.invK > Epsilon.E ? 1.0 / this.invK : 0.0;
            double d13 = step.getDeltaTimeRatio();
            this.impulse *= d13;
            Vector2 vector27 = this.n1.product(-this.impulse);
            Vector2 vector28 = this.n2.product(-this.ratio * this.impulse);
            this.body1.getLinearVelocity().add(vector27.product(d3));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d5 * vector2.cross(vector27));
            this.body2.getLinearVelocity().add(vector28.product(d4));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() + d6 * vector22.cross(vector28));
        } else {
            this.impulse = 0.0;
            this.limitState = Joint.LimitState.INACTIVE;
        }
    }

    @Override
    public void solveVelocityConstraints() {
        if (this.limitState != Joint.LimitState.INACTIVE) {
            Transform transform = this.body1.getTransform();
            Transform transform2 = this.body2.getTransform();
            Mass mass = this.body1.getMass();
            Mass mass2 = this.body2.getMass();
            double d = mass.getInverseMass();
            double d2 = mass2.getInverseMass();
            double d3 = mass.getInverseInertia();
            double d4 = mass2.getInverseInertia();
            Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
            Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
            double d5 = -this.n1.dot(vector23) - this.ratio * this.n2.dot(vector24);
            double d6 = this.invK * -d5;
            this.impulse += d6;
            Vector2 vector25 = this.n1.product(-d6);
            Vector2 vector26 = this.n2.product(-d6 * this.ratio);
            this.body1.getLinearVelocity().add(vector25.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector25));
            this.body2.getLinearVelocity().add(vector26.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() + d4 * vector22.cross(vector26));
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        if (this.limitState != Joint.LimitState.INACTIVE) {
            Settings settings = this.world.getSettings();
            double d = settings.getLinearTolerance();
            Transform transform = this.body1.getTransform();
            Transform transform2 = this.body2.getTransform();
            Mass mass = this.body1.getMass();
            Mass mass2 = this.body2.getMass();
            double d2 = mass.getInverseMass();
            double d3 = mass2.getInverseMass();
            double d4 = mass.getInverseInertia();
            double d5 = mass2.getInverseInertia();
            Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
            Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
            Vector2 vector23 = vector2.sum(this.body1.getWorldCenter());
            Vector2 vector24 = vector22.sum(this.body2.getWorldCenter());
            Vector2 vector25 = this.pulleyAnchor1;
            Vector2 vector26 = this.pulleyAnchor2;
            this.n1 = vector25.to(vector23);
            this.n2 = vector26.to(vector24);
            double d6 = this.n1.normalize();
            double d7 = this.n2.normalize();
            if (d6 <= 10.0 * d) {
                this.n1.zero();
            }
            if (d7 <= 10.0 * d) {
                this.n2.zero();
            }
            double d8 = 0.0;
            double d9 = vector2.cross(this.n1);
            double d10 = vector22.cross(this.n2);
            double d11 = d2 + d4 * d9 * d9;
            double d12 = d3 + d5 * d10 * d10;
            this.invK = d11 + this.ratio * this.ratio * d12;
            this.invK = this.invK > Epsilon.E ? 1.0 / this.invK : 0.0;
            double d13 = this.length - d6 - this.ratio * d7;
            d8 = Math.abs(d13);
            double d14 = -this.invK * d13;
            Vector2 vector27 = this.n1.product(-d14);
            Vector2 vector28 = this.n2.product(-this.ratio * d14);
            this.body1.translate(vector27.x * d2, vector27.y * d2);
            this.body1.rotateAboutCenter(vector2.cross(vector27) * d4);
            this.body2.translate(vector28.x * d3, vector28.y * d3);
            this.body2.rotateAboutCenter(vector22.cross(vector28) * d5);
            return d8 < d;
        }
        return true;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return this.n2.product(this.impulse * d);
    }

    @Override
    public double getReactionTorque(double d) {
        return 0.0;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
        this.pulleyAnchor1.add(vector2);
        this.pulleyAnchor2.add(vector2);
    }

    public Vector2 getPulleyAnchor1() {
        return this.pulleyAnchor1;
    }

    public Vector2 getPulleyAnchor2() {
        return this.pulleyAnchor2;
    }

    public double getLength() {
        return this.length;
    }

    public double getLength1() {
        Vector2 vector2 = this.body1.getWorldPoint(this.localAnchor1);
        return this.pulleyAnchor1.distance(vector2);
    }

    public double getLength2() {
        Vector2 vector2 = this.body2.getWorldPoint(this.localAnchor2);
        return this.pulleyAnchor2.distance(vector2);
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.pulley.invalidRatio"));
        }
        if (d != this.ratio) {
            this.ratio = d;
            this.length = this.length1 + this.ratio * this.length2;
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
    }

    public boolean isSlackEnabled() {
        return this.slackEnabled;
    }

    public void setSlackEnabled(boolean bl) {
        this.slackEnabled = bl;
    }
}

