/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.dynamics.joint;

import org.dyn4j.Epsilon;
import org.dyn4j.dynamics.Body;
import org.dyn4j.dynamics.Settings;
import org.dyn4j.dynamics.Step;
import org.dyn4j.dynamics.joint.Joint;
import org.dyn4j.geometry.Interval;
import org.dyn4j.geometry.Mass;
import org.dyn4j.geometry.Matrix22;
import org.dyn4j.geometry.Matrix33;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.geometry.Vector3;
import org.dyn4j.resources.Messages;

public class RevoluteJoint
extends Joint {
    protected Vector2 localAnchor1;
    protected Vector2 localAnchor2;
    protected boolean motorEnabled;
    protected double motorSpeed;
    protected double maximumMotorTorque;
    protected boolean limitEnabled;
    protected double upperLimit;
    protected double lowerLimit;
    protected double referenceAngle;
    protected Joint.LimitState limitState;
    protected Matrix33 K;
    protected double motorMass;
    protected Vector3 impulse;
    protected double motorImpulse;

    public RevoluteJoint(Body body, Body body2, Vector2 vector2) {
        super(body, body2, false);
        if (body == body2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.sameBody"));
        }
        if (vector2 == null) {
            throw new NullPointerException(Messages.getString("dynamics.joint.nullAnchor"));
        }
        this.localAnchor1 = body.getLocalPoint(vector2);
        this.localAnchor2 = body2.getLocalPoint(vector2);
        this.referenceAngle = body.getTransform().getRotation() - body2.getTransform().getRotation();
        this.limitState = Joint.LimitState.INACTIVE;
        this.impulse = new Vector3();
        this.K = new Matrix33();
        this.motorEnabled = false;
        this.limitEnabled = false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RevoluteJoint[").append(super.toString()).append("|LocalAnchor1=").append(this.localAnchor1).append("|LocalAnchor2=").append(this.localAnchor2).append("|WorldAnchor=").append(this.getAnchor1()).append("|IsMotorEnabled=").append(this.motorEnabled).append("|MotorSpeed=").append(this.motorSpeed).append("|MaximumMotorTorque=").append(this.maximumMotorTorque).append("|IsLimitEnabled=").append(this.limitEnabled).append("|LowerLimit=").append(this.lowerLimit).append("|UpperLimit=").append(this.upperLimit).append("|ReferenceAngle=").append(this.referenceAngle).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void initializeConstraints() {
        Step step = this.world.getStep();
        Settings settings = this.world.getSettings();
        double d = settings.getAngularTolerance();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d2 = mass.getInverseMass();
        double d3 = mass2.getInverseMass();
        double d4 = mass.getInverseInertia();
        double d5 = mass2.getInverseInertia();
        if (this.motorEnabled && d4 <= 0.0 && d5 <= 0.0) {
            throw new IllegalStateException(Messages.getString("dynamics.joint.revolute.twoAngularFixedBodies"));
        }
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        this.K.m00 = d2 + d3 + vector2.y * vector2.y * d4 + vector22.y * vector22.y * d5;
        this.K.m01 = -vector2.y * vector2.x * d4 - vector22.y * vector22.x * d5;
        this.K.m02 = -vector2.y * d4 - vector22.y * d5;
        this.K.m10 = this.K.m01;
        this.K.m11 = d2 + d3 + vector2.x * vector2.x * d4 + vector22.x * vector22.x * d5;
        this.K.m12 = vector2.x * d4 + vector22.x * d5;
        this.K.m20 = this.K.m02;
        this.K.m21 = this.K.m12;
        this.K.m22 = d4 + d5;
        this.motorMass = d4 + d5;
        if (this.motorMass > Epsilon.E) {
            this.motorMass = 1.0 / this.motorMass;
        }
        if (!this.motorEnabled) {
            this.motorImpulse = 0.0;
        }
        if (this.limitEnabled) {
            double d6 = this.getRelativeRotation();
            if (Math.abs(this.upperLimit - this.lowerLimit) < 2.0 * d) {
                this.limitState = Joint.LimitState.EQUAL;
            } else if (d6 <= this.lowerLimit) {
                if (this.limitState != Joint.LimitState.AT_LOWER) {
                    this.impulse.z = 0.0;
                }
                this.limitState = Joint.LimitState.AT_LOWER;
            } else if (d6 >= this.upperLimit) {
                if (this.limitState == Joint.LimitState.AT_UPPER) {
                    this.impulse.z = 0.0;
                }
                this.limitState = Joint.LimitState.AT_UPPER;
            } else {
                this.impulse.z = 0.0;
                this.limitState = Joint.LimitState.INACTIVE;
            }
        } else {
            this.limitState = Joint.LimitState.INACTIVE;
        }
        this.impulse.multiply(step.getDeltaTimeRatio());
        this.motorImpulse *= step.getDeltaTimeRatio();
        Vector2 vector23 = new Vector2(this.impulse.x, this.impulse.y);
        this.body1.getLinearVelocity().add(vector23.product(d2));
        this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d4 * (vector2.cross(vector23) + this.motorImpulse + this.impulse.z));
        this.body2.getLinearVelocity().subtract(vector23.product(d3));
        this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d5 * (vector22.cross(vector23) + this.motorImpulse + this.impulse.z));
    }

    @Override
    public void solveVelocityConstraints() {
        Step step = this.world.getStep();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d = mass.getInverseMass();
        double d2 = mass2.getInverseMass();
        double d3 = mass.getInverseInertia();
        double d4 = mass2.getInverseInertia();
        if (this.motorEnabled && this.limitState != Joint.LimitState.EQUAL) {
            double d5 = this.body1.getAngularVelocity() - this.body2.getAngularVelocity() - this.motorSpeed;
            double d6 = this.motorMass * -d5;
            double d7 = this.motorImpulse;
            double d8 = this.maximumMotorTorque * step.getDeltaTime();
            this.motorImpulse = Interval.clamp(this.motorImpulse + d6, -d8, d8);
            d6 = this.motorImpulse - d7;
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * d6);
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * d6);
        }
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getLinearVelocity().sum(vector2.cross(this.body1.getAngularVelocity()));
        Vector2 vector24 = this.body2.getLinearVelocity().sum(vector22.cross(this.body2.getAngularVelocity()));
        Vector2 vector25 = vector23.subtract(vector24);
        if (this.limitEnabled && this.limitState != Joint.LimitState.INACTIVE) {
            double d9;
            double d10 = this.body1.getAngularVelocity() - this.body2.getAngularVelocity();
            Vector3 vector3 = new Vector3(vector25.x, vector25.y, d10);
            Vector3 vector32 = this.K.solve33(vector3.negate());
            if (this.limitState == Joint.LimitState.EQUAL) {
                this.impulse.add(vector32);
            } else if (this.limitState == Joint.LimitState.AT_LOWER) {
                d9 = this.impulse.z + vector32.z;
                if (d9 < 0.0) {
                    Vector2 vector26 = this.K.solve22(vector25.negate());
                    vector32.x = vector26.x;
                    vector32.y = vector26.y;
                    vector32.z = -this.impulse.z;
                    this.impulse.x += vector26.x;
                    this.impulse.y += vector26.y;
                    this.impulse.z = 0.0;
                }
            } else if (this.limitState == Joint.LimitState.AT_UPPER && (d9 = this.impulse.z + vector32.z) > 0.0) {
                Vector2 vector27 = this.K.solve22(vector25.negate());
                vector32.x = vector27.x;
                vector32.y = vector27.y;
                vector32.z = -this.impulse.z;
                this.impulse.x += vector27.x;
                this.impulse.y += vector27.y;
                this.impulse.z = 0.0;
            }
            Vector2 vector28 = new Vector2(vector32.x, vector32.y);
            this.body1.getLinearVelocity().add(vector28.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * (vector2.cross(vector28) + vector32.z));
            this.body2.getLinearVelocity().subtract(vector28.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * (vector22.cross(vector28) + vector32.z));
        } else {
            Vector2 vector29 = this.K.solve22(vector25.negate());
            this.impulse.x += vector29.x;
            this.impulse.y += vector29.y;
            this.body1.getLinearVelocity().add(vector29.product(d));
            this.body1.setAngularVelocity(this.body1.getAngularVelocity() + d3 * vector2.cross(vector29));
            this.body2.getLinearVelocity().subtract(vector29.product(d2));
            this.body2.setAngularVelocity(this.body2.getAngularVelocity() - d4 * vector22.cross(vector29));
        }
    }

    @Override
    public boolean solvePositionConstraints() {
        Settings settings = this.world.getSettings();
        double d = settings.getLinearTolerance();
        double d2 = settings.getAngularTolerance();
        double d3 = settings.getMaximumAngularCorrection();
        Transform transform = this.body1.getTransform();
        Transform transform2 = this.body2.getTransform();
        Mass mass = this.body1.getMass();
        Mass mass2 = this.body2.getMass();
        double d4 = mass.getInverseMass();
        double d5 = mass2.getInverseMass();
        double d6 = mass.getInverseInertia();
        double d7 = mass2.getInverseInertia();
        double d8 = 0.0;
        double d9 = 0.0;
        if (this.limitEnabled && this.limitState != Joint.LimitState.INACTIVE) {
            double d10;
            double d11 = this.getRelativeRotation();
            double d12 = 0.0;
            if (this.limitState == Joint.LimitState.EQUAL) {
                d10 = Interval.clamp(d11 - this.lowerLimit, -d3, d3);
                d12 = -d10 * this.motorMass;
                d9 = Math.abs(d10);
            } else if (this.limitState == Joint.LimitState.AT_LOWER) {
                d10 = d11 - this.lowerLimit;
                d9 = -d10;
                d10 = Interval.clamp(d10 + d2, -d3, 0.0);
                d12 = -d10 * this.motorMass;
            } else if (this.limitState == Joint.LimitState.AT_UPPER) {
                d9 = d10 = d11 - this.upperLimit;
                d10 = Interval.clamp(d10 - d2, 0.0, d3);
                d12 = -d10 * this.motorMass;
            }
            this.body1.rotateAboutCenter(d6 * d12);
            this.body2.rotateAboutCenter(-d7 * d12);
        }
        Vector2 vector2 = transform.getTransformedR(this.body1.getLocalCenter().to(this.localAnchor1));
        Vector2 vector22 = transform2.getTransformedR(this.body2.getLocalCenter().to(this.localAnchor2));
        Vector2 vector23 = this.body1.getWorldCenter().add(vector2);
        Vector2 vector24 = this.body2.getWorldCenter().add(vector22);
        Vector2 vector25 = vector23.difference(vector24);
        d8 = vector25.getMagnitude();
        double d13 = 10.0 * d;
        if (vector25.getMagnitudeSquared() > d13 * d13) {
            double d14 = d4 + d5;
            if (d14 > Epsilon.E) {
                d14 = 1.0 / d14;
            }
            Vector2 vector26 = vector25.multiply(-d14);
            this.body1.translate(vector26.product(d4 * 0.5));
            this.body2.translate(vector26.product(-d5 * 0.5));
            vector23 = this.body1.getWorldCenter().add(vector2);
            vector24 = this.body2.getWorldCenter().add(vector22);
            vector25 = vector23.difference(vector24);
        }
        Matrix22 matrix22 = new Matrix22();
        matrix22.m00 = d4 + d5 + vector2.y * vector2.y * d6 + vector22.y * vector22.y * d7;
        matrix22.m01 = -d6 * vector2.x * vector2.y - d7 * vector22.x * vector22.y;
        matrix22.m10 = this.K.m01;
        matrix22.m11 = d4 + d5 + vector2.x * vector2.x * d6 + vector22.x * vector22.x * d7;
        Vector2 vector27 = matrix22.solve(vector25.negate());
        this.body1.translate(vector27.product(d4));
        this.body1.rotateAboutCenter(d6 * vector2.cross(vector27));
        this.body2.translate(vector27.product(-d5));
        this.body2.rotateAboutCenter(-d7 * vector22.cross(vector27));
        return d8 <= d && d9 <= d2;
    }

    private double getRelativeRotation() {
        double d = this.body1.getTransform().getRotation() - this.body2.getTransform().getRotation() - this.referenceAngle;
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        return d;
    }

    @Override
    public Vector2 getAnchor1() {
        return this.body1.getWorldPoint(this.localAnchor1);
    }

    @Override
    public Vector2 getAnchor2() {
        return this.body2.getWorldPoint(this.localAnchor2);
    }

    @Override
    public Vector2 getReactionForce(double d) {
        return new Vector2(this.impulse.x * d, this.impulse.y * d);
    }

    @Override
    public double getReactionTorque(double d) {
        return this.impulse.z * d;
    }

    @Override
    protected void shiftCoordinates(Vector2 vector2) {
    }

    public double getJointSpeed() {
        return this.body2.getAngularVelocity() - this.body1.getAngularVelocity();
    }

    public double getJointAngle() {
        return this.getRelativeRotation();
    }

    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    public void setMotorEnabled(boolean bl) {
        this.body1.setAsleep(false);
        this.body2.setAsleep(false);
        this.motorEnabled = bl;
    }

    public double getMaximumMotorTorque() {
        return this.maximumMotorTorque;
    }

    public void setMaximumMotorTorque(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidMaximumMotorTorque"));
        }
        this.maximumMotorTorque = d;
    }

    public double getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMotorSpeed(double d) {
        if (this.motorEnabled) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.motorSpeed = d;
    }

    public double getMotorTorque() {
        return this.motorImpulse;
    }

    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    public void setLimitEnabled(boolean bl) {
        if (this.limitEnabled != bl) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
            this.limitEnabled = bl;
            this.impulse.z = 0.0;
        }
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(double d) {
        if (d < this.lowerLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidUpperLimit"));
        }
        if (this.limitEnabled && d != this.upperLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.upperLimit = d;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double d) {
        if (d > this.upperLimit) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLowerLimit"));
        }
        if (this.limitEnabled && d != this.lowerLimit) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = d;
    }

    public void setLimits(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException(Messages.getString("dynamics.joint.invalidLimits"));
        }
        if (this.limitEnabled && (d != this.lowerLimit || d2 != this.upperLimit)) {
            this.body1.setAsleep(false);
            this.body2.setAsleep(false);
        }
        this.lowerLimit = d;
        this.upperLimit = d2;
    }

    public double getReferenceAngle() {
        return this.referenceAngle;
    }

    public void setReferenceAngle(double d) {
        this.referenceAngle = d;
    }
}

